/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.Iterator;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidEvaluationException;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractIterationManager;
import org.eclipse.ocl.examples.domain.library.LibraryTernaryOperation;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.NullValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.osgi.util.NLS;

public class ExecutorDoubleIterationManager
extends AbstractIterationManager {
    protected final DomainType returnType;
    protected final LibraryTernaryOperation body;
    private Value accumulatorValue;
    protected final CollectionValue collectionValue;
    private Iterator<Value> iteratorValue1;
    private final Iterator<Value> iteratorValue2;
    private Value currentValue1;
    private Value currentValue2;

    public ExecutorDoubleIterationManager(DomainEvaluator evaluator, DomainType returnType, LibraryTernaryOperation body, CollectionValue collectionValue, Value accumulatorValue) {
        super(evaluator);
        this.returnType = returnType;
        this.body = body;
        this.accumulatorValue = accumulatorValue;
        this.collectionValue = collectionValue;
        this.iteratorValue1 = collectionValue.iterator();
        this.iteratorValue2 = collectionValue.iterator();
        this.currentValue1 = this.iteratorValue1.hasNext() ? this.iteratorValue1.next() : null;
        this.currentValue2 = this.iteratorValue2.hasNext() ? this.iteratorValue2.next() : null;
    }

    public boolean advanceIterators() {
        if (this.iteratorValue1.hasNext()) {
            this.currentValue1 = this.iteratorValue1.next();
        } else if (this.iteratorValue2.hasNext()) {
            this.currentValue2 = this.iteratorValue2.next();
            this.iteratorValue1 = this.collectionValue.iterator();
            this.currentValue1 = this.iteratorValue1.hasNext() ? this.iteratorValue1.next() : null;
        } else {
            this.currentValue1 = null;
            this.currentValue2 = null;
        }
        return this.currentValue1 != null;
    }

    public Value evaluateBody() {
        try {
            return this.body.evaluate(this.evaluator, this.returnType, this.accumulatorValue, this.currentValue1, this.currentValue2);
        }
        catch (InvalidValueException e) {
            return this.throwInvalidEvaluation(e);
        }
    }

    public Value getAccumulatorValue() {
        return this.accumulatorValue;
    }

    public boolean hasCurrent() {
        return this.currentValue1 != null;
    }

    public NullValue throwInvalidEvaluation(String message, Object ... bindings) throws InvalidEvaluationException {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        throw new InvalidEvaluationException(null, boundMessage, null, null, null);
    }

    public Value updateBody() throws InvalidValueException {
        this.accumulatorValue = this.body.evaluate(this.evaluator, this.returnType, this.accumulatorValue, this.currentValue1, this.currentValue2);
        return null;
    }
}

