/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.Iterator;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidEvaluationException;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractIterationManager;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.NullValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.osgi.util.NLS;

public class ExecutorSingleIterationManager
extends AbstractIterationManager {
    protected final DomainType returnType;
    protected final LibraryBinaryOperation body;
    private Value accumulatorValue;
    protected final Iterator<Value> iteratorValue;
    private Value currentValue;

    public ExecutorSingleIterationManager(DomainEvaluator evaluator, DomainType returnType, LibraryBinaryOperation body, CollectionValue collectionValue, Value accumulatorValue) {
        super(evaluator);
        this.returnType = returnType;
        this.body = body;
        this.accumulatorValue = accumulatorValue;
        this.iteratorValue = collectionValue.iterator();
        this.advanceIterators();
    }

    public boolean advanceIterators() {
        Value value = this.currentValue = this.iteratorValue.hasNext() ? this.iteratorValue.next() : null;
        return this.currentValue != null;
    }

    public Value get() {
        return this.currentValue;
    }

    public Value getAccumulatorValue() {
        return this.accumulatorValue;
    }

    public Value evaluateBody() {
        try {
            return this.body.evaluate(this.evaluator, this.returnType, this.accumulatorValue, this.currentValue);
        }
        catch (InvalidValueException e) {
            return this.throwInvalidEvaluation(e);
        }
    }

    public boolean hasCurrent() {
        return this.currentValue != null;
    }

    public NullValue throwInvalidEvaluation(String message, Object ... bindings) throws InvalidEvaluationException {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        throw new InvalidEvaluationException(null, boundMessage, null, null, null);
    }

    public Value updateBody() throws InvalidValueException {
        this.accumulatorValue = this.body.evaluate(this.evaluator, this.returnType, this.accumulatorValue, this.currentValue);
        return null;
    }
}

