/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import org.eclipse.ocl.examples.domain.elements.DomainFragment;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.types.AbstractInheritance;
import org.eclipse.ocl.examples.library.executor.ExecutorFragment;
import org.eclipse.ocl.examples.library.executor.ExecutorPackage;
import org.eclipse.ocl.examples.library.executor.ExecutorStandardLibrary;
import org.eclipse.ocl.examples.library.executor.ExecutorTypeArgument;
import org.eclipse.ocl.examples.library.executor.ExecutorTypeParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorType
extends AbstractInheritance
implements DomainType,
ExecutorTypeArgument {
    private DomainFragment[] fragments = null;
    private int[] indexes = null;

    public ExecutorType(String name, ExecutorPackage evaluationPackage, int flags, ExecutorTypeParameter ... typeParameters) {
        super(name, (DomainPackage)evaluationPackage, flags);
    }

    public AbstractInheritance.FragmentIterable getAllSuperFragments() {
        return new AbstractInheritance.FragmentIterable(this.fragments);
    }

    public int getDepth() {
        return this.indexes.length - 2;
    }

    public DomainFragment getFragment(int fragmentNumber) {
        return this.fragments[fragmentNumber];
    }

    public int getIndex(int fragmentNumber) {
        return this.indexes[fragmentNumber];
    }

    public int getIndexes() {
        return this.indexes.length;
    }

    public Iterable<? extends DomainOperation> getLocalOperations() {
        return this.getSelfFragment().getLocalOperations();
    }

    public Iterable<? extends DomainProperty> getLocalProperties() {
        return this.getSelfFragment().getLocalProperties();
    }

    public Iterable<? extends DomainType> getLocalSuperTypes() {
        return this.getSelfFragment().getLocalSuperTypes();
    }

    public String getMetaTypeName() {
        throw new UnsupportedOperationException();
    }

    public ExecutorFragment getSelfFragment() {
        return (ExecutorFragment)this.getFragment(this.fragments.length - 1);
    }

    public DomainStandardLibrary getStandardLibrary() {
        return ExecutorStandardLibrary.INSTANCE;
    }

    public final AbstractInheritance.FragmentIterable getSuperFragments(int depth) {
        return new AbstractInheritance.FragmentIterable(this.fragments, this.indexes[depth], this.indexes[depth + 1]);
    }

    public DomainType getType() {
        return this;
    }

    public void initFragments(ExecutorFragment[] fragments, int[] depthCounts) {
        if (fragments != null) {
            int[] indexes = new int[depthCounts.length + 1];
            indexes[0] = 0;
            int i = 0;
            while (i < depthCounts.length) {
                indexes[i + 1] = indexes[i] + depthCounts[i];
                ++i;
            }
            this.fragments = fragments;
            this.indexes = indexes;
        } else {
            this.fragments = null;
            this.indexes = null;
        }
    }
}

