/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ocl.examples.domain.elements.DomainFragment;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.types.AbstractFragment;
import org.eclipse.ocl.examples.domain.utilities.IndexableIterable;

public abstract class ReflectiveFragment
extends AbstractFragment {
    protected Map<DomainOperation, LibraryFeature> operationMap = null;
    protected Map<DomainProperty, LibraryFeature> propertyMap = null;

    public ReflectiveFragment(DomainInheritance derivedInheritance, DomainInheritance baseInheritance) {
        super(derivedInheritance, baseInheritance);
    }

    public LibraryFeature getImplementation(DomainOperation baseOperation) {
        DomainOperation localOperation;
        if (this.operationMap != null) {
            LibraryFeature libraryFeature = this.operationMap.get(baseOperation);
            if (libraryFeature != null) {
                return libraryFeature;
            }
        } else {
            this.operationMap = new HashMap<DomainOperation, LibraryFeature>();
        }
        if ((localOperation = this.getOperationOverload(baseOperation)) == null) {
            localOperation = baseOperation;
        }
        LibraryFeature libraryFeature = localOperation.getImplementation();
        if (this.derivedInheritance == this.baseInheritance) {
            assert (localOperation == baseOperation);
        } else if (libraryFeature == null) {
            int depth = this.derivedInheritance.getDepth();
            ArrayList<Integer> multiDepths = null;
            HashSet<DomainInheritance> multiOverrides = null;
            IndexableIterable superFragments = this.derivedInheritance.getSuperFragments(depth - 1);
            if (superFragments.size() > 1) {
                int i = depth - 2;
                while (i > 0) {
                    IndexableIterable superSuperFragments = this.derivedInheritance.getSuperFragments(i);
                    if (superSuperFragments.size() > 1) {
                        if (multiDepths == null) {
                            multiDepths = new ArrayList<Integer>();
                            multiOverrides = new HashSet<DomainInheritance>();
                        }
                        multiDepths.add(i);
                    }
                    --i;
                }
            }
            for (DomainFragment derivedSuperFragment : superFragments) {
                DomainFragment superFragment;
                DomainInheritance superInheritance = derivedSuperFragment.getBaseInheritance();
                if (multiDepths != null) {
                    for (Integer multiDepth : multiDepths) {
                        for (DomainFragment superSuperFragment : superInheritance.getSuperFragments(multiDepth.intValue())) {
                            HashSet<DomainInheritance> nonNullMultiOverrides = multiOverrides;
                            nonNullMultiOverrides.add(superSuperFragment.getBaseInheritance());
                        }
                    }
                }
                if ((superFragment = superInheritance.getFragment(this.baseInheritance)) == null) continue;
                LibraryFeature superFeature = superFragment.getImplementation(baseOperation);
                if (libraryFeature == null) {
                    libraryFeature = superFeature;
                    continue;
                }
                assert (libraryFeature == superFeature);
            }
            if (multiDepths != null) {
                for (Integer multiDepth : multiDepths) {
                    Iterator iterator = this.derivedInheritance.getSuperFragments(multiDepth.intValue()).iterator();
                    while (iterator.hasNext()) {
                        DomainFragment superFragment;
                        HashSet<DomainInheritance> nonNullMultiOverrides = multiOverrides;
                        DomainFragment superSuperFragment = (DomainFragment)iterator.next();
                        DomainInheritance superSuperInheritance = superSuperFragment.getBaseInheritance();
                        if (nonNullMultiOverrides.contains(superSuperInheritance) || (superFragment = superSuperInheritance.getFragment(this.baseInheritance)) == null) continue;
                        LibraryFeature superFeature = superFragment.getImplementation(baseOperation);
                        if (libraryFeature == null) {
                            libraryFeature = superFeature;
                            continue;
                        }
                        assert (libraryFeature == superFeature);
                    }
                }
            }
        }
        this.operationMap.put(baseOperation, libraryFeature);
        return libraryFeature;
    }

    protected abstract DomainOperation getOperationOverload(DomainOperation var1);
}

