/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.executor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.library.executor.ExecutorPackage;
import org.eclipse.ocl.examples.library.executor.ReflectiveType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectivePackage
extends ExecutorPackage {
    protected Map<DomainType, ReflectiveType> types = null;

    public ReflectivePackage(String name, String nsURI) {
        super(name, nsURI);
    }

    protected void computeClasses() {
        this.types = new HashMap<DomainType, ReflectiveType>();
        for (DomainType domainType : this.getDomainTypes()) {
            ReflectiveType executorType = this.createExecutorType(domainType);
            this.types.put(domainType, executorType);
        }
    }

    protected abstract ReflectiveType createExecutorType(DomainType var1);

    protected abstract Iterable<? extends DomainType> getDomainTypes();

    public ReflectiveType getInheritance(DomainType type) {
        if (this.types == null) {
            this.computeClasses();
        }
        return this.types.get(type);
    }

    public Iterable<? extends DomainType> getOwnedType() {
        if (this.types == null) {
            this.computeClasses();
        }
        return this.types.values();
    }

    protected abstract DomainStandardLibrary getStandardLibrary();
}

