/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class AnyIteration
extends AbstractIteration {
    public static final AnyIteration INSTANCE = new AnyIteration();

    public CollectionValue.Accumulator createAccumulatorValue(DomainEvaluator evaluator, DomainType accumulatorType, DomainType bodyType) {
        ValueFactory valueFactory = evaluator.getValueFactory();
        DomainStandardLibrary standardLibrary = valueFactory.getStandardLibrary();
        return valueFactory.createCollectionAccumulatorValue(standardLibrary.getSequenceType(accumulatorType));
    }

    protected Value resolveTerminalValue(DomainIterationManager iterationManager) {
        CollectionValue.Accumulator accumulatorValue = (CollectionValue.Accumulator)iterationManager.getAccumulatorValue();
        if (accumulatorValue.intSize() > 0) {
            return (Value)accumulatorValue.asList().get(0);
        }
        return iterationManager.getValueFactory().getNull();
    }

    protected Value updateAccumulator(DomainIterationManager iterationManager) {
        Value bodyVal = iterationManager.evaluateBody();
        if (bodyVal.isUndefined()) {
            return iterationManager.throwInvalidEvaluation(EvaluatorMessages.UndefinedBody, new Object[]{"any"});
        }
        if (bodyVal.isFalse()) {
            return null;
        }
        CollectionValue.Accumulator accumulatorValue = (CollectionValue.Accumulator)iterationManager.getAccumulatorValue();
        if (accumulatorValue.intSize() > 0) {
            return iterationManager.getValueFactory().getFalse();
        }
        Value value = iterationManager.get();
        accumulatorValue.add(value);
        return null;
    }
}

