/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.library.LibraryValidator;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class ClosureIteration
extends AbstractIteration {
    public static final ClosureIteration INSTANCE = new ClosureIteration();
    private static LibraryValidator validator = null;

    public CollectionValue.Accumulator createAccumulatorValue(DomainEvaluator evaluator, DomainType accumulatorType, DomainType bodyType) {
        return evaluator.getValueFactory().createCollectionAccumulatorValue((DomainCollectionType)accumulatorType);
    }

    public LibraryValidator getValidator(DomainStandardLibrary standardLibrary) {
        if (validator == null) {
            validator = ClosureIteration.getLibraryValidator((Object)standardLibrary, (String)"org.eclipse.ocl.examples.pivot.library.validators.ValidateClosureIteration");
        }
        return validator;
    }

    protected Value updateAccumulator(DomainIterationManager iterationManager) {
        Value bodyVal;
        if (!iterationManager.isOuterIteration()) {
            Value value = iterationManager.get();
            CollectionValue.Accumulator accumulatorValue = (CollectionValue.Accumulator)iterationManager.getAccumulatorValue();
            if (!accumulatorValue.add(value)) {
                return accumulatorValue;
            }
        }
        if ((bodyVal = iterationManager.evaluateBody()).isInvalid()) {
            return bodyVal;
        }
        if (bodyVal.isUndefined()) {
            return iterationManager.getAccumulatorValue();
        }
        try {
            CollectionValue collectionValue;
            if (bodyVal instanceof CollectionValue) {
                collectionValue = (CollectionValue)bodyVal;
            } else {
                ValueFactory valueFactory = iterationManager.getValueFactory();
                collectionValue = valueFactory.createSequenceValue(valueFactory.getStandardLibrary().getSequenceType(bodyVal.getType()), new Value[]{bodyVal});
            }
            this.evaluateIteration(iterationManager.createNestedIterationManager(collectionValue));
        }
        catch (InvalidValueException e) {
            iterationManager.throwInvalidEvaluation(e);
        }
        return null;
    }
}

