/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.Value;

public class CollectIteration
extends AbstractIteration {
    public static final CollectIteration INSTANCE = new CollectIteration();

    public CollectionValue.Accumulator createAccumulatorValue(DomainEvaluator evaluator, DomainType accumulatorType, DomainType bodyType) {
        return evaluator.getValueFactory().createCollectionAccumulatorValue((DomainCollectionType)accumulatorType);
    }

    protected Value updateAccumulator(DomainIterationManager iterationManager) {
        CollectionValue.Accumulator accumulatorValue = (CollectionValue.Accumulator)iterationManager.getAccumulatorValue();
        Value bodyVal = iterationManager.evaluateBody();
        if (bodyVal.isNull()) {
            accumulatorValue.add(bodyVal);
        } else if (bodyVal instanceof CollectionValue) {
            CollectionValue bodyColl = (CollectionValue)bodyVal;
            try {
                for (Value value : bodyColl.flatten()) {
                    accumulatorValue.add(value);
                }
            }
            catch (InvalidValueException e) {
                iterationManager.throwInvalidEvaluation(e);
            }
        } else {
            accumulatorValue.add(bodyVal);
        }
        return null;
    }
}

