/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.BooleanValue;
import org.eclipse.ocl.examples.domain.values.Value;

public class ExistsIteration
extends AbstractIteration {
    public static final ExistsIteration INSTANCE = new ExistsIteration();

    public BooleanValue.Accumulator createAccumulatorValue(DomainEvaluator evaluator, DomainType accumulatorType, DomainType bodyType) {
        return evaluator.getValueFactory().createBooleanAccumulatorValue();
    }

    protected Value resolveTerminalValue(DomainIterationManager iterationManager) {
        return iterationManager.getValueFactory().getFalse();
    }

    protected Value updateAccumulator(DomainIterationManager iterationManager) {
        Value bodyVal = iterationManager.evaluateBody();
        if (bodyVal.isUndefined()) {
            return iterationManager.throwInvalidEvaluation(EvaluatorMessages.UndefinedBody, new Object[]{"exists"});
        }
        if (bodyVal.isFalse()) {
            return null;
        }
        return iterationManager.getValueFactory().getTrue();
    }
}

