/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class IsUniqueIteration
extends AbstractIteration {
    public static final IsUniqueIteration INSTANCE = new IsUniqueIteration();

    public CollectionValue.Accumulator createAccumulatorValue(DomainEvaluator evaluator, DomainType accumulatorType, DomainType bodyType) {
        ValueFactory valueFactory = evaluator.getValueFactory();
        DomainStandardLibrary standardLibrary = valueFactory.getStandardLibrary();
        return valueFactory.createCollectionAccumulatorValue(standardLibrary.getSetType(accumulatorType));
    }

    protected Value resolveTerminalValue(DomainIterationManager iterationManager) {
        return iterationManager.getValueFactory().getTrue();
    }

    protected Value updateAccumulator(DomainIterationManager iterationManager) {
        CollectionValue.Accumulator accumulatorValue = (CollectionValue.Accumulator)iterationManager.getAccumulatorValue();
        Value bodyVal = iterationManager.evaluateBody();
        try {
            if (accumulatorValue.includes(bodyVal).isTrue()) {
                return iterationManager.getValueFactory().getFalse();
            }
            accumulatorValue.add(bodyVal);
            return null;
        }
        catch (InvalidValueException e) {
            return iterationManager.throwInvalidEvaluation(e);
        }
    }
}

