/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.iterator;

import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.DomainIterationManager;
import org.eclipse.ocl.examples.domain.library.AbstractIteration;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.BooleanValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class OneIteration
extends AbstractIteration {
    public static final OneIteration INSTANCE = new OneIteration();

    public BooleanValue.Accumulator createAccumulatorValue(DomainEvaluator evaluator, DomainType accumulatorType, DomainType bodyType) {
        ValueFactory valueFactory = evaluator.getValueFactory();
        return valueFactory.createBooleanAccumulatorValue();
    }

    protected Value updateAccumulator(DomainIterationManager iterationManager) {
        Value bodyVal = iterationManager.evaluateBody();
        if (bodyVal.isUndefined()) {
            return iterationManager.throwInvalidEvaluation(EvaluatorMessages.UndefinedBody, new Object[]{"one"});
        }
        if (bodyVal.isFalse()) {
            return null;
        }
        Value accumulatorValue = iterationManager.getAccumulatorValue();
        if (accumulatorValue.isTrue()) {
            return iterationManager.getValueFactory().getFalse();
        }
        ((BooleanValue.Accumulator)accumulatorValue).setValue(true);
        return null;
    }
}

