/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.logical;

import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.domain.values.BooleanValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class BooleanImpliesOperation
extends AbstractBinaryOperation {
    public static final BooleanImpliesOperation INSTANCE = new BooleanImpliesOperation();

    public boolean argumentsMayBeInvalid() {
        return true;
    }

    public BooleanValue evaluate(DomainEvaluator evaluator, DomainType returnType, Value left, Value right) throws InvalidValueException {
        ValueFactory valueFactory = evaluator.getValueFactory();
        if (left.isFalse()) {
            return valueFactory.getTrue();
        }
        if (right.isTrue()) {
            return valueFactory.getTrue();
        }
        return valueFactory.booleanValueOf(!left.asBoolean() || right.asBoolean());
    }
}

