/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.numeric;

import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNumericBinaryOperation
extends AbstractBinaryOperation {
    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value left, Value right) throws InvalidValueException {
        if (left.isUnlimited() || right.isUnlimited()) {
            return this.evaluateUnlimited(evaluator, left, right);
        }
        IntegerValue leftInteger = left.isIntegerValue();
        IntegerValue rightInteger = right.isIntegerValue();
        if (leftInteger != null && rightInteger != null) {
            return this.evaluateInteger(evaluator, leftInteger, rightInteger);
        }
        RealValue leftReal = left.toRealValue();
        RealValue rightReal = right.toRealValue();
        return this.evaluateReal(evaluator, leftReal, rightReal);
    }

    protected abstract Value evaluateInteger(DomainEvaluator var1, IntegerValue var2, IntegerValue var3) throws InvalidValueException;

    protected Value evaluateReal(DomainEvaluator evaluator, RealValue left, RealValue right) throws InvalidValueException {
        return null;
    }

    protected Value evaluateUnlimited(DomainEvaluator evaluator, Value left, Value right) throws InvalidValueException {
        return null;
    }

    protected <T extends Number> Object evaluate(DomainEvaluator evaluator, T left, T right) throws InvalidValueException {
        return null;
    }
}

