/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.numeric;

import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractUnaryOperation;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.NumericValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNumericUnaryOperation
extends AbstractUnaryOperation {
    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceVal) throws InvalidValueException {
        if (sourceVal.isUnlimited()) {
            return this.evaluateUnlimited(sourceVal);
        }
        IntegerValue integerValue = sourceVal.isIntegerValue();
        if (integerValue != null) {
            return this.evaluateInteger(integerValue);
        }
        RealValue realValue = sourceVal.toRealValue();
        return this.evaluateReal(realValue);
    }

    protected Value evaluateReal(RealValue left) throws InvalidValueException {
        return this.evaluateNumeric(left);
    }

    protected Value evaluateInteger(IntegerValue left) throws InvalidValueException {
        return this.evaluateNumeric(left);
    }

    protected Value evaluateUnlimited(Object left) throws InvalidValueException {
        return null;
    }

    protected <T extends NumericValue> Value evaluateNumeric(T left) throws InvalidValueException {
        return null;
    }
}

