/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.numeric;

import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.values.BooleanValue;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.library.numeric.AbstractNumericBinaryOperation;

public class NumericLessThanOperation
extends AbstractNumericBinaryOperation {
    public static final NumericLessThanOperation INSTANCE = new NumericLessThanOperation();

    protected BooleanValue evaluateInteger(DomainEvaluator evaluator, IntegerValue left, IntegerValue right) {
        ValueFactory valueFactory = evaluator.getValueFactory();
        return valueFactory.booleanValueOf(left.compareTo((Object)right) < 0);
    }

    protected BooleanValue evaluateReal(DomainEvaluator evaluator, RealValue left, RealValue right) {
        ValueFactory valueFactory = evaluator.getValueFactory();
        return valueFactory.booleanValueOf(left.compareTo((Object)right) < 0);
    }

    protected BooleanValue evaluateUnlimited(DomainEvaluator evaluator, Value left, Value right) {
        ValueFactory valueFactory = evaluator.getValueFactory();
        return valueFactory.booleanValueOf(!left.isUnlimited() && right.isUnlimited());
    }
}

