/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.numeric;

import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.TypeValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.library.oclany.OclAnyOclAsTypeOperation;

public class UnlimitedNaturalOclAsTypeOperation
extends OclAnyOclAsTypeOperation {
    public static final UnlimitedNaturalOclAsTypeOperation INSTANCE = new UnlimitedNaturalOclAsTypeOperation();

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceVal, Value argVal) throws InvalidValueException {
        TypeValue typeVal;
        DomainType argType;
        ValueFactory valueFactory = evaluator.getValueFactory();
        DomainType sourceType = sourceVal.getType();
        if (sourceType == null) {
            return valueFactory.throwInvalidValueException(EvaluatorMessages.MissingSourceType, new Object[0]);
        }
        DomainStandardLibrary standardLibrary = valueFactory.getStandardLibrary();
        if (sourceType.conformsTo(standardLibrary, argType = (typeVal = argVal.asTypeValue()).getInstanceType())) {
            if (sourceVal.isUnlimited() && (argType == standardLibrary.getRealType() || argType == standardLibrary.getIntegerType())) {
                return valueFactory.throwInvalidValueException(EvaluatorMessages.NonFiniteIntegerValue, new Object[0]);
            }
            return sourceVal;
        }
        return valueFactory.throwInvalidValueException(EvaluatorMessages.IncompatibleArgumentType, new Object[]{argType});
    }
}

