/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.oclany;

import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public abstract class OclComparableComparisonOperation
extends AbstractBinaryOperation {
    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value left, Value right) throws InvalidValueException {
        int intComparison;
        LibraryBinaryOperation implementation;
        ValueFactory valueFactory = evaluator.getValueFactory();
        DomainStandardLibrary standardLibrary = valueFactory.getStandardLibrary();
        DomainInheritance leftType = left.getType().getInheritance(standardLibrary);
        DomainInheritance rightType = right.getType().getInheritance(standardLibrary);
        DomainInheritance commonType = leftType.getCommonInheritance(rightType);
        DomainInheritance comparableType = standardLibrary.getOclComparableType().getInheritance(standardLibrary);
        DomainInheritance selfType = standardLibrary.getOclSelfType().getInheritance(standardLibrary);
        DomainOperation staticOperation = comparableType.lookupLocalOperation(standardLibrary, EvaluatorMessages.CompareToOperation, new DomainInheritance[]{selfType});
        try {
            implementation = (LibraryBinaryOperation)commonType.lookupImplementation(standardLibrary, staticOperation);
        }
        catch (Exception e) {
            throw new InvalidValueException((Throwable)e);
        }
        if (implementation != null) {
            Value comparison = implementation.evaluate(evaluator, standardLibrary.getIntegerType(), left, right);
            intComparison = comparison.asInteger();
        } else {
            int comparison;
            Object leftObject = left.asObject();
            Object rightObject = right.asObject();
            if (!(leftObject instanceof Comparable)) {
                return valueFactory.throwInvalidValueException("Unsupported compareTo for ''{0}''", new Object[]{left.getClass().getName()});
            }
            intComparison = comparison = ((Comparable)leftObject).compareTo(rightObject);
        }
        return valueFactory.booleanValueOf(this.getResultValue(intComparison));
    }

    protected abstract boolean getResultValue(Integer var1);
}

