/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.string;

import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.domain.values.Value;

public class StringAtOperation
extends AbstractBinaryOperation {
    public static final StringAtOperation INSTANCE = new StringAtOperation();

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value left, Value right) throws InvalidValueException {
        String leftString = left.asString();
        Integer rightInteger = right.asInteger();
        if (leftString != null && rightInteger != null) {
            int size = leftString.length();
            int index = rightInteger;
            if (index > 0 && index <= size) {
                char c = leftString.charAt(index - 1);
                return evaluator.getValueFactory().stringValueOf(String.valueOf(c));
            }
        }
        return null;
    }
}

