/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.string;

import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractTernaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class StringSubstituteFirstOperation
extends AbstractTernaryOperation {
    public static final StringSubstituteFirstOperation INSTANCE = new StringSubstituteFirstOperation();

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceValue, Value firstArgumentValue, Value secondArgumentValue) throws InvalidValueException {
        ValueFactory valueFactory = evaluator.getValueFactory();
        String sourceString = sourceValue.asString();
        String oldSubstring = firstArgumentValue.asString();
        String newSubstring = secondArgumentValue.asString();
        int index = sourceString.indexOf(oldSubstring);
        if (index < 0) {
            return valueFactory.throwInvalidValueException(EvaluatorMessages.MissingSubstring, new Object[]{oldSubstring, sourceString});
        }
        return valueFactory.stringValueOf(String.valueOf(sourceString.substring(0, index)) + newSubstring + sourceString.substring(index + oldSubstring.length(), sourceString.length()));
    }
}

