/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.string;

import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractTernaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class StringSubstringOperation
extends AbstractTernaryOperation {
    public static final StringSubstringOperation INSTANCE = new StringSubstringOperation();

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceValue, Value firstArgumentValue, Value secondArgumentValue) throws InvalidValueException {
        ValueFactory valueFactory = evaluator.getValueFactory();
        String sourceString = sourceValue.asString();
        Integer startInteger = firstArgumentValue.asInteger();
        Integer endInteger = secondArgumentValue.asInteger();
        int size = sourceString.length();
        int lower = startInteger;
        int upper = endInteger;
        if (lower > 0 && lower <= upper && upper <= size) {
            return valueFactory.stringValueOf(sourceString.substring(lower - 1, upper));
        }
        return valueFactory.throwInvalidValueException(EvaluatorMessages.IndexesOutOfRange, new Object[]{lower, upper, size});
    }
}

