/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.string;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidEvaluationException;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractOperation;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryTernaryOperation;
import org.eclipse.ocl.examples.domain.library.LibraryUnaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.StringValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public class StringTokenizeOperation
extends AbstractOperation
implements LibraryUnaryOperation,
LibraryBinaryOperation,
LibraryTernaryOperation {
    public static final StringTokenizeOperation INSTANCE = new StringTokenizeOperation();
    private static final String DELIMS = " \t\n\r\f";

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceValue) throws InvalidValueException {
        return this.evaluate(evaluator, (DomainCollectionType)returnType, sourceValue, DELIMS, false);
    }

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceValue, Value argumentValue) throws InvalidValueException {
        boolean returnDelims = argumentValue.asBoolean();
        return this.evaluate(evaluator, (DomainCollectionType)returnType, sourceValue, DELIMS, returnDelims);
    }

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value sourceValue, Value firstArgumentValue, Value secondArgumentValue) throws InvalidValueException {
        String delims = firstArgumentValue.asString();
        boolean returnDelims = secondArgumentValue.asBoolean();
        return this.evaluate(evaluator, (DomainCollectionType)returnType, sourceValue, delims, returnDelims);
    }

    public Value evaluate(DomainEvaluator evaluator, DomainCallExp callExp, Value sourceValue, Value ... argumentValues) throws InvalidEvaluationException, InvalidValueException {
        String delims = DELIMS;
        boolean returnDelims = false;
        if (argumentValues.length > 0) {
            if (argumentValues.length > 1) {
                if (argumentValues.length > 2) {
                    return evaluator.getValueFactory().throwInvalidValueException(EvaluatorMessages.InvalidArgument, new Object[]{argumentValues[2]});
                }
                returnDelims = argumentValues[1].asBoolean();
            }
            delims = argumentValues[0].asString();
        }
        return this.evaluate(evaluator, (DomainCollectionType)callExp.getType(), sourceValue, delims, returnDelims);
    }

    public Value evaluate(DomainEvaluator evaluator, DomainCollectionType returnType, Value sourceValue, String delims, boolean returnDelims) throws InvalidValueException {
        ValueFactory valueFactory = evaluator.getValueFactory();
        String sourceString = sourceValue.asString();
        StringTokenizer tokenizer = new StringTokenizer(sourceString, delims, returnDelims);
        ArrayList<StringValue> results = new ArrayList<StringValue>();
        while (tokenizer.hasMoreTokens()) {
            results.add(valueFactory.stringValueOf(tokenizer.nextToken()));
        }
        return valueFactory.createSequenceValue(returnType, results);
    }
}

