/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.ui;

import java.util.Collection;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class OCLPropertyTester
extends PropertyTester {
    private static final String RESOURCE_SET_AVAILABLE = "resourceSetAvailable";

    public static XtextEditor getActiveXtextEditor(IEvaluationContext evaluationContext) {
        Object o = HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        if (!(o instanceof IEditorPart)) {
            return null;
        }
        XtextEditor xtextEditor = (XtextEditor)((IEditorPart)o).getAdapter(XtextEditor.class);
        return xtextEditor;
    }

    private boolean hasResourceSet(Object receiver) {
        if (receiver instanceof IStructuredSelection) {
            receiver = ((IStructuredSelection)receiver).getFirstElement();
        }
        if (receiver instanceof EObject) {
            Resource resource = ((EObject)receiver).eResource();
            return resource != null && resource.getResourceSet() != null;
        }
        if (receiver instanceof Resource) {
            return ((Resource)receiver).getResourceSet() != null;
        }
        if (receiver instanceof ResourceSet) {
            return true;
        }
        if (receiver instanceof TextSelection) {
            IEvaluationContext evaluationContext = OCLPropertyTester.getApplicationContext();
            XtextEditor xtextEditor = OCLPropertyTester.getActiveXtextEditor(evaluationContext);
            return xtextEditor != null;
        }
        return false;
    }

    public static IEvaluationContext getApplicationContext() {
        IEvaluationService es = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        return es == null ? null : es.getCurrentState();
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (RESOURCE_SET_AVAILABLE.equals(property)) {
            if (receiver instanceof Collection) {
                for (Object aReceiver : (Collection)receiver) {
                    if (!this.hasResourceSet(aReceiver)) continue;
                    return true;
                }
            } else {
                return this.hasResourceSet(receiver);
            }
        }
        return false;
    }
}

