/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot;

import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.pivot.AbstractEnvironment;
import org.eclipse.ocl.examples.pivot.Adaptable;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitorImpl;
import org.eclipse.ocl.examples.pivot.evaluation.TracingEvaluationVisitor;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnvironmentFactory
implements EnvironmentFactory,
Adaptable {
    private boolean traceEvaluation;

    protected AbstractEnvironmentFactory() {
    }

    protected Environment createPackageContext(Environment parent, Package context) {
        Environment result = this.createEnvironment(parent);
        if (result instanceof AbstractEnvironment) {
            ((AbstractEnvironment)result).setContextPackage(context);
        }
        return result;
    }

    @Override
    public Environment createClassifierContext(Environment parent, Type context) {
        Environment result = this.createEnvironment(parent);
        Variable self = parent.getOCLFactory().createVariable();
        self.setName("self");
        self.setType(context);
        result.setSelfVariable(self);
        return result;
    }

    @Override
    public Environment createInstanceContext(Environment parent, Object context) {
        return this.createClassifierContext(parent, this.getClassifier(context));
    }

    @Override
    public Environment createOperationContext(Environment parent, Operation operation) {
        Environment result = this.createEnvironment(parent);
        if (result instanceof AbstractEnvironment) {
            ((AbstractEnvironment)result).setContextOperation(operation);
        }
        PivotFactory oclFactory = parent.getOCLFactory();
        for (Parameter next : operation.getOwnedParameter()) {
            Variable var = oclFactory.createVariable();
            var.setName(next.getName());
            var.setType(next.getType());
            var.setRepresentedParameter(next);
        }
        return result;
    }

    @Override
    public Environment createPropertyContext(Environment parent, Property property) {
        Environment result = this.createEnvironment(parent);
        if (result instanceof AbstractEnvironment) {
            ((AbstractEnvironment)result).setContextProperty(property);
        }
        return result;
    }

    @Override
    public EvaluationVisitor createEvaluationVisitor(Environment env, EvaluationEnvironment evalEnv, DomainModelManager modelManager) {
        AbstractExtendingVisitor result = new EvaluationVisitorImpl(env, evalEnv, modelManager);
        if (this.isEvaluationTracingEnabled()) {
            result = new TracingEvaluationVisitor((EvaluationVisitor)((Object)result));
        }
        return result;
    }

    protected abstract Type getClassifier(Object var1);

    protected boolean isEvaluationTracingEnabled() {
        return this.traceEvaluation;
    }

    public void setEvaluationTracingEnabled(boolean b) {
        this.traceEvaluation = b;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        AbstractEnvironmentFactory result = adapterType.isAssignableFrom(this.getClass()) ? this : null;
        return (T)result;
    }
}

