/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.context;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.context.Base2PivotConversion;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceAdapter;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractParserContext
implements ParserContext {
    protected final MetaModelManager metaModelManager;
    protected final URI uri;

    protected AbstractParserContext(MetaModelManager metaModelManager, URI uri) {
        this.metaModelManager = metaModelManager;
        this.uri = uri;
    }

    public BaseResource createBaseResource(String expression) throws IOException {
        URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(expression, "UTF-8");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(this.uri);
        BaseResource baseResource = (BaseResource)resource;
        MetaModelManagerResourceAdapter.getAdapter(resource, this.metaModelManager);
        baseResource.setParserContext(this);
        baseResource.load((InputStream)inputStream, null);
        return baseResource;
    }

    public Type getClassContext() {
        return null;
    }

    public ExpressionInOCL getExpression(BaseResource resource) throws ParserException {
        Element pivotElement;
        EList contents = resource.getContents();
        int size = contents.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new ParserException("Extra returns ignored");
        }
        EObject csObject = (EObject)contents.get(0);
        if (csObject instanceof Pivotable && (pivotElement = ((Pivotable)csObject).getPivot()) instanceof ExpressionInOCL) {
            return (ExpressionInOCL)pivotElement;
        }
        throw new ParserException("Non-expression ignored");
    }

    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public URI getURI() {
        return this.uri;
    }

    public void initialize(Base2PivotConversion conversion, ExpressionInOCL expression) {
        EList<String> language = expression.getLanguage();
        language.clear();
        language.add("OCL");
    }

    public ExpressionInOCL parse(String expression) throws ParserException {
        BaseResource resource = null;
        try {
            resource = this.createBaseResource(expression);
            PivotUtil.checkResourceErrors(NLS.bind((String)OCLMessages.ErrorsInResource, (Object)expression), resource);
            ExpressionInOCL expressionInOCL = this.getExpression(resource);
            return expressionInOCL;
        }
        catch (IOException e) {
            ExpressionInOCL specification = PivotFactory.eINSTANCE.createExpressionInOCL();
            InvalidLiteralExp invalidValueBody = this.metaModelManager.createInvalidExpression();
            specification.setBodyExpression(invalidValueBody);
            ExpressionInOCL expressionInOCL = specification;
            return expressionInOCL;
        }
        finally {
            MetaModelManagerResourceAdapter adapter;
            if (resource != null && (adapter = MetaModelManagerResourceAdapter.findAdapter(resource)) != null) {
                adapter.dispose();
            }
        }
    }
}

