/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.ocl.examples.pivot.Comment;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ValueSpecification;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2EcoreDeclarationVisitor;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2EcoreReferenceVisitor;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2Ecore
extends AbstractConversion {
    public static final Logger logger = Logger.getLogger(Pivot2Ecore.class);
    public static final String PRIMITIVE_TYPES_URI_PREFIX = "PRIMITIVE_TYPES_URI_PREFIX";
    private Map<Element, EModelElement> createMap = new HashMap<Element, EModelElement>();
    Set<Element> deferMap = new HashSet<Element>();
    private List<Resource.Diagnostic> errors = null;
    protected final Pivot2EcoreDeclarationVisitor pass1 = new Pivot2EcoreDeclarationVisitor(this);
    protected final Pivot2EcoreReferenceVisitor pass2 = new Pivot2EcoreReferenceVisitor(this);
    protected final URI ecoreURI;
    protected final Map<String, Object> options;
    protected final String primitiveTypesUriPrefix;

    public static void copyComments(EModelElement eModelElement, Element pivotElement) {
        for (Comment comment : pivotElement.getOwnedComment()) {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
            String body = comment.getBody();
            eAnnotation.getDetails().put((Object)"documentation", (Object)body);
            eModelElement.getEAnnotations().add((Object)eAnnotation);
        }
    }

    public static EOperation createConstraintEOperation(Constraint pivotConstraint, String operationName) {
        String body;
        EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
        eOperation.setName(operationName != null ? operationName : "");
        eOperation.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
        EParameter firstParameter = EcoreFactory.eINSTANCE.createEParameter();
        firstParameter.setName("diagnostics");
        firstParameter.setEType((EClassifier)EcorePackage.Literals.EDIAGNOSTIC_CHAIN);
        eOperation.getEParameters().add((Object)firstParameter);
        EParameter secondParameter = EcoreFactory.eINSTANCE.createEParameter();
        secondParameter.setName("context");
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setEClassifier((EClassifier)EcorePackage.Literals.EMAP);
        EGenericType firstTypeArgument = EcoreFactory.eINSTANCE.createEGenericType();
        firstTypeArgument.setEClassifier((EClassifier)EcorePackage.Literals.EJAVA_OBJECT);
        eGenericType.getETypeArguments().add((Object)firstTypeArgument);
        EGenericType secondTypeArgument = EcoreFactory.eINSTANCE.createEGenericType();
        secondTypeArgument.setEClassifier((EClassifier)EcorePackage.Literals.EJAVA_OBJECT);
        eGenericType.getETypeArguments().add((Object)secondTypeArgument);
        secondParameter.setEGenericType(eGenericType);
        eOperation.getEParameters().add((Object)secondParameter);
        ValueSpecification specification = pivotConstraint.getSpecification();
        if (specification instanceof OpaqueExpression && (body = PivotUtil.getBody((OpaqueExpression)specification)) != null) {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
            eAnnotation.getDetails().put((Object)"body", (Object)body);
            eOperation.getEAnnotations().add((Object)eAnnotation);
        }
        Pivot2Ecore.copyComments((EModelElement)eOperation, pivotConstraint);
        return eOperation;
    }

    public static XMLResource createResource(MetaModelManager metaModelManager, Resource pivotResource, URI ecoreURI, Map<String, Object> options) {
        ResourceSet resourceSet = metaModelManager.getExternalResourceSet();
        XMLResource ecoreResource = (XMLResource)resourceSet.createResource(ecoreURI);
        EList contents = ecoreResource.getContents();
        EList pivotRoots = pivotResource.getContents();
        Pivot2Ecore converter = new Pivot2Ecore(metaModelManager, ecoreURI, options);
        List<EObject> outputObjects = converter.convertAll((List<? extends EObject>)pivotRoots);
        for (EObject eObject : outputObjects) {
            if (!(eObject instanceof EPackage) || "$$".equals(((EPackage)eObject).getName())) continue;
            EList eSubpackages = ((EPackage)eObject).getESubpackages();
            contents.addAll(eSubpackages);
            eSubpackages.clear();
        }
        return ecoreResource;
    }

    public static Boolean getBoolean(Map<String, Object> options, String key) {
        if (options == null) {
            return false;
        }
        Object value = options.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        logger.error((Object)("Non-Boolean '" + key + "'"));
        return false;
    }

    public static String getString(Map<String, Object> options, String key) {
        if (options == null) {
            return null;
        }
        Object value = options.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        logger.error((Object)("Non-String '" + key + "'"));
        return null;
    }

    public static boolean installDelegate(EModelElement eModelElement, Constraint pivotConstraint, URI ecoreURI) {
        ValueSpecification specification = pivotConstraint.getSpecification();
        if (!(specification instanceof OpaqueExpression)) {
            return false;
        }
        String exprString = PivotUtil.getBody((OpaqueExpression)specification);
        Namespace namespace = PivotUtil.getNamespace(specification);
        PrettyPrintOptions.Global options = PrettyPrinter.createOptions(namespace);
        options.setBaseURI(ecoreURI);
        if (exprString == null && specification instanceof ExpressionInOCL) {
            exprString = PrettyPrinter.print((Element)((ExpressionInOCL)specification).getBodyExpression(), options);
        }
        if (exprString == null) {
            return false;
        }
        EList eAnnotations = eModelElement.getEAnnotations();
        EAnnotation oclAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        if (oclAnnotation == null) {
            oclAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            oclAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
            eAnnotations.add(oclAnnotation);
        }
        String stereotype = pivotConstraint.getStereotype();
        String name = pivotConstraint.getName();
        if ("invariant".equals(stereotype)) {
            if (eModelElement instanceof EOperation) {
                oclAnnotation.getDetails().put((Object)"body", (Object)exprString);
            } else {
                OCLExpression messageExpression;
                oclAnnotation.getDetails().put((Object)name, (Object)exprString);
                String messageString = PivotUtil.getMessage((OpaqueExpression)specification);
                if (messageString == null && specification instanceof ExpressionInOCL && (messageExpression = ((ExpressionInOCL)specification).getMessageExpression()) != null) {
                    messageString = PrettyPrinter.print((Element)messageExpression, options);
                }
                if (messageString != null && messageString.length() > 0) {
                    oclAnnotation.getDetails().put((Object)(String.valueOf(name) + "$message"), (Object)messageString);
                }
            }
        } else if ("derivation".equals(stereotype)) {
            oclAnnotation.getDetails().put((Object)"derivation", (Object)exprString);
        } else if ("initial".equals(stereotype)) {
            oclAnnotation.getDetails().put((Object)"initial", (Object)exprString);
        } else if ("body".equals(stereotype)) {
            String key = name != null ? "body_" + name : "body";
            oclAnnotation.getDetails().put((Object)key, (Object)exprString);
        } else if ("precondition".equals(stereotype)) {
            oclAnnotation.getDetails().put((Object)("pre_" + name), (Object)exprString);
        } else if ("postcondition".equals(stereotype)) {
            oclAnnotation.getDetails().put((Object)("post_" + name), (Object)exprString);
        }
        oclAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL");
        if (oclAnnotation != null) {
            eAnnotations.remove(oclAnnotation);
        }
        if ((oclAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/LPG")) != null) {
            eAnnotations.remove(oclAnnotation);
        }
        if ((oclAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel")) != null) {
            eAnnotations.remove(oclAnnotation);
        }
        return true;
    }

    public static void installDelegate(MetaModelManager metaModelManager, EOperation eOperation) {
        EList eAnnotations = eOperation.getEAnnotations();
        EAnnotation oclAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel");
        if (oclAnnotation != null) {
            eAnnotations.remove(oclAnnotation);
            oclAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
            eAnnotations.add(oclAnnotation);
        }
    }

    public static void installDelegate(MetaModelManager metaModelManager, EStructuralFeature eFeature) {
        EList eAnnotations = eFeature.getEAnnotations();
        EAnnotation oclAnnotation = eFeature.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel");
        if (oclAnnotation != null) {
            eAnnotations.remove(oclAnnotation);
            oclAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
            eAnnotations.add(oclAnnotation);
        }
    }

    public static void installDelegates(MetaModelManager metaModelManager, EClassifier eClassifier, Type pivotType) {
        StringBuilder s = null;
        for (Constraint pivotConstraint : metaModelManager.getLocalConstraints(pivotType)) {
            String constraintName = pivotConstraint.getName();
            if (pivotConstraint.isCallable() || constraintName == null) continue;
            if (s == null) {
                s = new StringBuilder();
            } else {
                s.append(" ");
            }
            s.append(constraintName);
        }
        EAnnotation eAnnotation = eClassifier.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (s != null) {
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
                eClassifier.getEAnnotations().add(0, (Object)eAnnotation);
            }
            eAnnotation.getDetails().put((Object)"constraints", (Object)s.toString());
        } else {
            eClassifier.getEAnnotations().remove((Object)eAnnotation);
        }
    }

    public static void installDelegates(EPackage ePackage) {
        EAnnotation packageAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (packageAnnotation == null) {
            packageAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            packageAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
            ePackage.getEAnnotations().add((Object)packageAnnotation);
        }
        EMap details = packageAnnotation.getDetails();
        details.put((Object)"invocationDelegates", (Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        details.put((Object)"settingDelegates", (Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
        details.put((Object)"validationDelegates", (Object)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
    }

    public Pivot2Ecore(MetaModelManager metaModelManager, URI ecoreURI, Map<String, Object> options) {
        super(metaModelManager);
        this.ecoreURI = ecoreURI;
        this.options = options;
        this.primitiveTypesUriPrefix = Pivot2Ecore.getString(options, PRIMITIVE_TYPES_URI_PREFIX);
    }

    protected EObject convert(Element pivotObject) {
        EObject eObject = (EObject)this.pass1.safeVisit(pivotObject);
        for (Element eKey : this.deferMap) {
            this.pass2.safeVisit(eKey);
        }
        return eObject;
    }

    protected List<EObject> convertAll(List<? extends EObject> pivotObjects) {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        for (EObject eObject : pivotObjects) {
            if (!(eObject instanceof Element)) continue;
            eObjects.add((EObject)this.pass1.safeVisit((Visitable)eObject));
        }
        for (Element element : this.deferMap) {
            this.pass2.safeVisit(element);
        }
        return eObjects;
    }

    public void defer(Element pivotElement) {
        this.deferMap.add(pivotElement);
    }

    protected void error(String message) {
        if (this.errors == null) {
            this.errors = new ArrayList<Resource.Diagnostic>();
        }
        this.errors.add((Resource.Diagnostic)new XMIException(message));
    }

    public <T extends EObject> T getCreated(Class<T> requiredClass, Element pivotElement) {
        Element primaryElement;
        EModelElement eModelElement = this.createMap.get(pivotElement);
        if (eModelElement == null && pivotElement != (primaryElement = this.metaModelManager.getPrimaryElement(pivotElement))) {
            eModelElement = this.createMap.get(primaryElement);
        }
        if (eModelElement == null) {
            return null;
        }
        if (!requiredClass.isAssignableFrom(eModelElement.getClass())) {
            logger.error((Object)("Ecore " + eModelElement.getClass().getName() + "' element is not a '" + requiredClass.getName() + "'"));
            return null;
        }
        EModelElement castElement = eModelElement;
        return (T)castElement;
    }

    public final URI getEcoreURI() {
        return this.ecoreURI;
    }

    public final MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public String getPrimitiveTypesUriPrefix() {
        return this.primitiveTypesUriPrefix;
    }

    public void putCreated(Element pivotElement, EModelElement eModelElement) {
        Element primaryElement = this.metaModelManager.getPrimaryElement(pivotElement);
        EModelElement oldPivot = this.createMap.put(pivotElement, eModelElement);
        assert (oldPivot == null);
        if (pivotElement != primaryElement) {
            EModelElement oldPrimary = this.createMap.put(primaryElement, eModelElement);
            assert (oldPrimary == null);
        }
    }
}

