/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.TypeTracker;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2EcoreTypeRefVisitor
extends AbstractExtendingVisitor<EObject, Pivot2Ecore> {
    protected final MetaModelManager metaModelManager;

    public Pivot2EcoreTypeRefVisitor(Pivot2Ecore context) {
        super(context);
        this.metaModelManager = context.getMetaModelManager();
    }

    public EGenericType resolveEGenericType(Type type) {
        EObject eType = this.safeVisit(type);
        if (eType instanceof EGenericType) {
            return (EGenericType)eType;
        }
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setEClassifier((EClassifier)eType);
        return eGenericType;
    }

    @Override
    public EObject safeVisit(Visitable v) {
        if (v instanceof Type) {
            v = this.metaModelManager.getPrimaryType((Type)v);
        }
        return v == null ? null : v.accept(this);
    }

    public <T extends EObject> void safeVisitAll(List<T> eObjects, List<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            EObject eObject = this.safeVisit(element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    @Override
    public EClassifier visiting(Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for Pivot2Ecore TypeRef pass");
    }

    @Override
    public EObject visitAnyType(AnyType object) {
        return EcorePackage.Literals.EOBJECT;
    }

    @Override
    public EObject visitCollectionType(CollectionType object) {
        return (EObject)super.visitCollectionType(object);
    }

    @Override
    public EObject visitInvalidType(InvalidType object) {
        return EcorePackage.Literals.EOBJECT;
    }

    @Override
    public EObject visitPrimitiveType(PrimitiveType pivotType) {
        String uri = ((Pivot2Ecore)((Object)this.context)).getPrimitiveTypesUriPrefix();
        if (uri != null) {
            EDataType eClassifier = ((Pivot2Ecore)((Object)this.context)).getCreated(EDataType.class, pivotType);
            if (eClassifier == null) {
                URI proxyURI = URI.createURI((String)(String.valueOf(uri) + pivotType.getName()));
                eClassifier = EcoreFactory.eINSTANCE.createEDataType();
                ((InternalEObject)eClassifier).eSetProxyURI(proxyURI);
                ((Pivot2Ecore)((Object)this.context)).putCreated(pivotType, (EModelElement)eClassifier);
            }
            return eClassifier;
        }
        TypeTracker typeTracker = this.metaModelManager.findTypeTracker(pivotType);
        if (typeTracker != null) {
            for (Type aType : typeTracker.getTypeServer().getTypes()) {
                EDataType eClassifier;
                if (aType instanceof PrimitiveType || (eClassifier = ((Pivot2Ecore)((Object)this.context)).getCreated(EDataType.class, pivotType)) == null) continue;
                return eClassifier;
            }
        }
        if (pivotType == this.metaModelManager.getBooleanType()) {
            return EcorePackage.Literals.EBOOLEAN;
        }
        if (pivotType == this.metaModelManager.getIntegerType()) {
            return EcorePackage.Literals.EBIG_INTEGER;
        }
        if (pivotType == this.metaModelManager.getRealType()) {
            return EcorePackage.Literals.EBIG_DECIMAL;
        }
        if (pivotType == this.metaModelManager.getStringType()) {
            return EcorePackage.Literals.ESTRING;
        }
        if (pivotType == this.metaModelManager.getUnlimitedNaturalType()) {
            return EcorePackage.Literals.EBIG_INTEGER;
        }
        throw new IllegalArgumentException("Unsupported primitive type '" + pivotType + "' in Pivot2Ecore TypeRef pass");
    }

    @Override
    public EObject visitTemplateBinding(TemplateBinding object) {
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        return eGenericType;
    }

    @Override
    public EObject visitTemplateParameterSubstitution(TemplateParameterSubstitution pivotTemplateParameterSubstitution) {
        EObject actualType = this.safeVisit(pivotTemplateParameterSubstitution.getActual());
        if (actualType instanceof EGenericType) {
            return actualType;
        }
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setEClassifier((EClassifier)actualType);
        return eGenericType;
    }

    @Override
    public EObject visitType(Type pivotType) {
        TemplateParameter templateParameter = pivotType.getTemplateParameter();
        if (templateParameter != null) {
            ETypeParameter eTypeParameter = ((Pivot2Ecore)((Object)this.context)).getCreated(ETypeParameter.class, templateParameter);
            EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
            eGenericType.setETypeParameter(eTypeParameter);
            return eGenericType;
        }
        EList templateBindings = pivotType.getTemplateBinding();
        if (templateBindings.size() == 0) {
            EClassifier eClassifier = ((Pivot2Ecore)((Object)this.context)).getCreated(EClassifier.class, pivotType);
            if (eClassifier != null) {
                return eClassifier;
            }
            return pivotType.getETarget();
        }
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        EObject rawType = this.safeVisit(PivotUtil.getUnspecializedTemplateableElement(pivotType));
        eGenericType.setEClassifier((EClassifier)rawType);
        this.safeVisitAll((List)eGenericType.getETypeArguments(), (List<? extends Element>)((TemplateBinding)templateBindings.get(0)).getParameterSubstitution());
        return eGenericType;
    }

    @Override
    public EObject visitVoidType(VoidType object) {
        return EcorePackage.Literals.EOBJECT;
    }
}

