/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.executor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.domain.elements.DomainEnumeration;
import org.eclipse.ocl.examples.domain.elements.DomainEnumerationLiteral;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorEnumerationLiteral;
import org.eclipse.ocl.examples.library.executor.ExecutorEnumerationLiteral;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.executor.PivotReflectivePackage;
import org.eclipse.ocl.examples.pivot.executor.PivotReflectiveType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotReflectiveEnumerationType
extends PivotReflectiveType
implements DomainEnumeration {
    private Map<String, DomainEnumerationLiteral> literals = new HashMap<String, DomainEnumerationLiteral>();

    public PivotReflectiveEnumerationType(PivotReflectivePackage executorPackage, Enumeration type) {
        super(executorPackage, type);
        int index = 0;
        EObject eTarget = type.getETarget();
        if (eTarget instanceof EEnum) {
            for (EEnumLiteral eLiteral : ((EEnum)eTarget).getELiterals()) {
                String enumerationLiteralName = eLiteral.getName();
                this.literals.put(enumerationLiteralName, (DomainEnumerationLiteral)new EcoreExecutorEnumerationLiteral(eLiteral, (DomainEnumeration)this, index++));
            }
        } else {
            for (EnumerationLiteral enumerationLiteral : type.getOwnedLiteral()) {
                String enumerationLiteralName = enumerationLiteral.getName();
                this.literals.put(enumerationLiteralName, (DomainEnumerationLiteral)new ExecutorEnumerationLiteral(enumerationLiteralName, (DomainEnumeration)this, index++));
            }
        }
    }

    public DomainEnumerationLiteral getEnumerationLiteral(String name) {
        return this.literals.get(name);
    }

    public Iterable<? extends DomainEnumerationLiteral> getEnumerationLiterals() {
        return this.literals.values();
    }
}

