/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.helper;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.context.ClassContext;
import org.eclipse.ocl.examples.pivot.context.OperationContext;
import org.eclipse.ocl.examples.pivot.context.PropertyContext;
import org.eclipse.ocl.examples.pivot.helper.OCLHelper;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironment;

public class OCLHelperImpl
implements OCLHelper {
    private final OCL ocl;
    protected final Environment rootEnvironment;
    protected final MetaModelManager metaModelManager;
    protected final EnvironmentFactory environmentFactory;
    private Environment env;
    private boolean validating = true;
    private Diagnostic problems;

    public OCLHelperImpl(OCL ocl) {
        this.ocl = ocl;
        this.rootEnvironment = ocl.getEnvironment();
        this.metaModelManager = this.rootEnvironment.getMetaModelManager();
        this.environmentFactory = this.rootEnvironment.getFactory();
    }

    public ExpressionInOCL createBodyCondition(String expression) throws ParserException {
        PivotEnvironment environment = (PivotEnvironment)this.getEnvironment();
        MetaModelManager metaModelManager = environment.getMetaModelManager();
        Operation contextOperation = environment.getContextOperation();
        URI uri = metaModelManager.getResourceIdentifier(expression, null);
        OperationContext parserContext = new OperationContext(metaModelManager, uri, contextOperation, null);
        return parserContext.parse(expression);
    }

    public ExpressionInOCL createDerivedValueExpression(String expression) throws ParserException {
        Property contextProperty = this.getEnvironment().getContextProperty();
        URI uri = this.metaModelManager.getResourceIdentifier(expression, null);
        PropertyContext parserContext = new PropertyContext(this.metaModelManager, uri, contextProperty);
        return parserContext.parse(expression);
    }

    public ExpressionInOCL createInvariant(String expression) throws ParserException {
        Type contextClassifier = this.getEnvironment().getContextClassifier();
        URI uri = this.metaModelManager.getResourceIdentifier(expression, null);
        ClassContext parserContext = new ClassContext(this.metaModelManager, uri, contextClassifier);
        return parserContext.parse(expression);
    }

    public ExpressionInOCL createPostcondition(String expression) throws ParserException {
        Operation contextOperation = this.getEnvironment().getContextOperation();
        URI uri = this.metaModelManager.getResourceIdentifier(expression, null);
        OperationContext parserContext = new OperationContext(this.metaModelManager, uri, contextOperation, "result");
        return parserContext.parse(expression);
    }

    public ExpressionInOCL createPrecondition(String expression) throws ParserException {
        Operation contextOperation = this.getEnvironment().getContextOperation();
        URI uri = this.metaModelManager.getResourceIdentifier(expression, null);
        OperationContext parserContext = new OperationContext(this.metaModelManager, uri, contextOperation, null);
        return parserContext.parse(expression);
    }

    public ExpressionInOCL createQuery(String expression) throws ParserException {
        Type contextClassifier = this.getEnvironment().getContextClassifier();
        URI uri = this.metaModelManager.getResourceIdentifier(expression, null);
        ClassContext parserContext = new ClassContext(this.metaModelManager, uri, contextClassifier);
        return parserContext.parse(expression);
    }

    protected ExpressionInOCL createSpecification(String expression) throws ParserException {
        Type contextClassifier = this.getEnvironment().getContextClassifier();
        URI uri = this.metaModelManager.getResourceIdentifier(expression, null);
        ClassContext parserContext = new ClassContext(this.metaModelManager, uri, contextClassifier);
        return parserContext.parse(expression);
    }

    public Property getContextProperty() {
        return this.getEnvironment().getContextProperty();
    }

    public Type getContextClassifier() {
        return this.getEnvironment().getContextClassifier();
    }

    public Operation getContextOperation() {
        return this.getEnvironment().getContextOperation();
    }

    public Environment getEnvironment() {
        return this.env == null ? this.rootEnvironment : this.env;
    }

    public OCL getOCL() {
        return this.ocl;
    }

    public Diagnostic getProblems() {
        return this.problems;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setContext(EClassifier context) {
        Type pContext = this.metaModelManager.getPivotOfEcore(Type.class, (EObject)context);
        this.setContext(pContext);
    }

    public void setContext(Type context) {
        this.setEnvironment(this.environmentFactory.createClassifierContext(this.getEnvironment(), context));
    }

    private void setEnvironment(Environment env) {
        this.env = env;
    }

    public void setInstancePropertyContext(Object instance, Property property) {
        this.setInstanceContext(instance);
        this.setEnvironment(this.environmentFactory.createPropertyContext(this.getEnvironment(), property));
    }

    public void setInstanceContext(Object instance) {
        this.setEnvironment(this.environmentFactory.createInstanceContext(this.getEnvironment(), instance));
    }

    public void setInstanceOperationContext(Object instance, Operation operation) {
        this.setInstanceContext(instance);
        this.setEnvironment(this.environmentFactory.createOperationContext(this.getEnvironment(), operation));
    }

    public void setOperationContext(EClassifier context, EOperation operation) {
        Type pContext = this.metaModelManager.getPivotOfEcore(Type.class, (EObject)context);
        Operation pOperation = this.metaModelManager.getPivotOfEcore(Operation.class, (EObject)operation);
        this.setOperationContext(pContext, pOperation);
    }

    public void setOperationContext(Type context, Operation operation) {
        this.setContext(context);
        this.setEnvironment(this.environmentFactory.createOperationContext(this.getEnvironment(), operation));
    }

    public void setPropertyContext(EClassifier context, EStructuralFeature property) {
        Type pContext = this.metaModelManager.getPivotOfEcore(Type.class, (EObject)context);
        Property pProperty = this.metaModelManager.getPivotOfEcore(Property.class, (EObject)property);
        this.setPropertyContext(pContext, pProperty);
    }

    public void setPropertyContext(Type context, Property property) {
        this.setContext(context);
        this.setEnvironment(this.environmentFactory.createPropertyContext(this.getEnvironment(), property));
    }

    void setProblems(Diagnostic problems) {
        this.problems = problems;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }
}

