/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.internal.impl;

import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorManager;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorType;
import org.eclipse.ocl.examples.library.oclstdlib.OCLstdlibTables;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.PivotTables;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.bodies.IntegerLiteralExpBodies;
import org.eclipse.ocl.examples.pivot.internal.impl.NumericLiteralExpImpl;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerLiteralExpImpl
extends NumericLiteralExpImpl
implements IntegerLiteralExp {
    protected static final BigInteger INTEGER_SYMBOL_EDEFAULT = null;
    protected BigInteger integerSymbol = INTEGER_SYMBOL_EDEFAULT;

    protected IntegerLiteralExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.INTEGER_LITERAL_EXP;
    }

    @Override
    public BigInteger getIntegerSymbol() {
        return this.integerSymbol;
    }

    @Override
    public void setIntegerSymbol(BigInteger newIntegerSymbol) {
        BigInteger oldIntegerSymbol = this.integerSymbol;
        this.integerSymbol = newIntegerSymbol;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldIntegerSymbol, (Object)this.integerSymbol));
        }
    }

    @Override
    public boolean validateTypeIsInteger(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean resultIsNull;
        block4: {
            try {
                EcoreExecutorType T_Boolean;
                EcoreExecutorManager evaluator = new EcoreExecutorManager((EObject)this, null, (DomainStandardLibrary)PivotTables.LIBRARY);
                ValueFactory valueFactory = evaluator.getValueFactory();
                Value self = valueFactory.valueOf((Object)this);
                EcoreExecutorType returnType = T_Boolean = OCLstdlibTables.Types._Boolean;
                Value result = IntegerLiteralExpBodies._invariant_TypeIsInteger.INSTANCE.evaluate((DomainEvaluator)evaluator, (DomainType)returnType, self);
                resultIsNull = result.isNull();
                if (resultIsNull || !result.asBoolean()) break block4;
                return true;
            }
            catch (InvalidValueException e) {
                String message = NLS.bind((String)EvaluatorMessages.ValidationEvaluationFailed_ERROR_, (Object[])new Object[]{"IntegerLiteralExp", "TypeIsInteger", EObjectValidator.getObjectLabel((EObject)this, context)});
                throw new WrappedException(message, (Exception)((Object)e));
            }
        }
        if (diagnostics != null) {
            int severity = resultIsNull ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IntegerLiteralExp", "TypeIsInteger", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 12, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getOwnedComment();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getOwnedRule();
            }
            case 3: {
                return this.isStatic();
            }
            case 4: {
                return this.getOwnedAnnotation();
            }
            case 5: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 6: {
                return this.getIntegerSymbol();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getOwnedComment().clear();
                this.getOwnedComment().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.getOwnedRule().clear();
                this.getOwnedRule().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setIsStatic((Boolean)newValue);
                return;
            }
            case 4: {
                this.getOwnedAnnotation().clear();
                this.getOwnedAnnotation().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setType((Type)newValue);
                return;
            }
            case 6: {
                this.setIntegerSymbol((BigInteger)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getOwnedComment().clear();
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.getOwnedRule().clear();
                return;
            }
            case 3: {
                this.setIsStatic(false);
                return;
            }
            case 4: {
                this.getOwnedAnnotation().clear();
                return;
            }
            case 5: {
                this.setType(null);
                return;
            }
            case 6: {
                this.setIntegerSymbol(INTEGER_SYMBOL_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.ownedComment != null && !this.ownedComment.isEmpty();
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.ownedRule != null && !this.ownedRule.isEmpty();
            }
            case 3: {
                return (this.eFlags & 0x100) != 0;
            }
            case 4: {
                return this.ownedAnnotation != null && !this.ownedAnnotation.isEmpty();
            }
            case 5: {
                return this.type != null;
            }
            case 6: {
                return INTEGER_SYMBOL_EDEFAULT == null ? this.integerSymbol != null : !INTEGER_SYMBOL_EDEFAULT.equals(this.integerSymbol);
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.validateNotOwnSelf((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 2: {
                return this.validateTypeIsInteger((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visitIntegerLiteralExp(this);
    }
}

