/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import java.lang.reflect.Method;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.AbstractBinaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.osgi.util.NLS;

public class JavaCompareToOperation
extends AbstractBinaryOperation {
    protected final Method method;

    public JavaCompareToOperation(Method method) {
        this.method = method;
    }

    public Value evaluate(DomainEvaluator evaluator, DomainType returnType, Value leftValue, Value rightValue) throws InvalidValueException {
        ValueFactory valueFactory = evaluator.getValueFactory();
        Object leftObject = leftValue.asObject();
        Object rightObject = rightValue.asObject();
        try {
            Object result = this.method.invoke(leftObject, rightObject);
            if (!(result instanceof Integer)) {
                return this.throwInvalidValueException(EvaluatorMessages.TypedResultRequired, "Integer");
            }
            return valueFactory.integerValueOf(((Integer)result).intValue());
        }
        catch (Exception e) {
            throw new InvalidValueException((Throwable)e);
        }
    }

    protected Value throwInvalidValueException(String message, Object ... bindings) throws InvalidValueException {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        throw new InvalidValueException(boundMessage);
    }
}

