/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.pivot.Library;
import org.eclipse.ocl.examples.pivot.Model;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;
import org.eclipse.ocl.examples.pivot.manager.PackageTracker;
import org.eclipse.ocl.examples.pivot.manager.TypeTracker;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageManager {
    protected final MetaModelManager metaModelManager;
    private final Map<String, Package> uri2package = new HashMap<String, Package>();
    private final Map<String, List<String>> name2uris = new HashMap<String, List<String>>();
    private final Map<Package, PackageTracker> package2tracker = new HashMap<Package, PackageTracker>();
    private final Map<Type, TypeTracker> type2tracker = new HashMap<Type, TypeTracker>();

    protected PackageManager(MetaModelManager metaModelManager) {
        this.metaModelManager = metaModelManager;
    }

    public void addPackage(Package pivotPackage) {
        String nsURI = pivotPackage.getNsURI();
        Package primaryPackage = null;
        if (nsURI != null) {
            primaryPackage = this.getPackageByURI(nsURI);
        } else {
            String name = pivotPackage.getName();
            if (name != null) {
                primaryPackage = this.getPackageByName(name);
            }
            if (primaryPackage == null) {
                nsURI = PivotUtil.getNsURI(pivotPackage);
                primaryPackage = this.getPackageByURI(nsURI);
            }
        }
        if (primaryPackage != pivotPackage) {
            if (primaryPackage != null) {
                PackageTracker packageTracker = this.getPackageTracker(primaryPackage);
                packageTracker.getPackageServer().addSecondaryPackage(pivotPackage);
            } else {
                this.putPackage(nsURI, pivotPackage);
            }
        }
    }

    void addPackageTracker(Package pivotPackage, PackageTracker packageTracker) {
        PackageTracker oldTracker = this.package2tracker.put(pivotPackage, packageTracker);
        assert (oldTracker == null);
    }

    void addTypeTracker(Type pivotType, TypeTracker typeTracker) {
        TypeTracker oldTracker = this.type2tracker.put(pivotType, typeTracker);
        assert (oldTracker == null);
    }

    void addedNestedPrimaryPackage(Package pivotPackage) {
        String nsURI = PivotUtil.getNsURI(pivotPackage);
        Package primaryPackage = this.getPackageByURI(nsURI);
        if (primaryPackage != pivotPackage) {
            if (primaryPackage != null) {
                throw new IllegalArgumentException("Duplicate nsURI '" + nsURI + "'");
            }
            this.putPackage(nsURI, pivotPackage);
        }
    }

    public void dispose() {
        if (!this.package2tracker.isEmpty()) {
            ArrayList<PackageTracker> savedPackageTrackers = new ArrayList<PackageTracker>(this.package2tracker.values());
            this.package2tracker.clear();
            for (PackageTracker packageTracker : savedPackageTrackers) {
                if (!(packageTracker instanceof PackageServer)) continue;
                packageTracker.dispose();
            }
        }
        if (!this.type2tracker.isEmpty()) {
            ArrayList<TypeTracker> savedTypeTrackers = new ArrayList<TypeTracker>(this.type2tracker.values());
            this.type2tracker.clear();
            for (TypeTracker typeTracker : savedTypeTrackers) {
                typeTracker.dispose();
            }
        }
        this.uri2package.clear();
        this.name2uris.clear();
    }

    public PackageTracker findPackageTracker(Package pivotPackage) {
        return this.package2tracker.get(pivotPackage);
    }

    public TypeTracker findTypeTracker(Type pivotType) {
        return this.type2tracker.get(pivotType);
    }

    public Iterable<Package> getAllPackages() {
        return this.uri2package.values();
    }

    public MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public Package getPackageByName(String name) {
        List<String> uriList = this.name2uris.get(name);
        if (uriList == null || uriList.isEmpty()) {
            return null;
        }
        Package selectedPackage = this.getPackageByURI(uriList.get(0));
        int i = 1;
        while (i < uriList.size()) {
            Package anotherPackage = this.getPackageByURI(uriList.get(i));
            if (anotherPackage != selectedPackage) {
                throw new IllegalArgumentException("Ambiguous package name '" + name + "'");
            }
            ++i;
        }
        return selectedPackage;
    }

    public Package getPackageByURI(String nsURI) {
        return this.uri2package.get(nsURI);
    }

    public PackageTracker getPackageTracker(Package pivotPackage) {
        PackageTracker packageTracker = this.findPackageTracker(pivotPackage);
        if (packageTracker == null && (packageTracker = (PackageTracker)EcoreUtil.getAdapter((List)pivotPackage.eAdapters(), (Object)this)) == null) {
            packageTracker = new PackageServer(this, pivotPackage);
        }
        return packageTracker;
    }

    protected void putPackage(String nsURI, Package pivotPackage) {
        this.uri2package.put(nsURI, pivotPackage);
        String name = pivotPackage.getName();
        if (name != null && (pivotPackage instanceof Library || !(pivotPackage instanceof Model))) {
            List<String> uriList = this.name2uris.get(name);
            if (uriList == null) {
                uriList = new ArrayList<String>();
                this.name2uris.put(name, uriList);
            }
            if (!uriList.contains(nsURI)) {
                uriList.add(nsURI);
            }
        }
    }

    void removePackageTracker(PackageTracker packageTracker) {
        this.package2tracker.remove(packageTracker.getTarget());
    }

    void removeTypeTracker(TypeTracker typeTracker) {
        this.type2tracker.remove(typeTracker.getTarget());
    }
}

