/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.library.executor.ReflectiveType;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.executor.PivotReflectivePackage;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.Orphanage;
import org.eclipse.ocl.examples.pivot.manager.PackageManager;
import org.eclipse.ocl.examples.pivot.manager.TypeClient;
import org.eclipse.ocl.examples.pivot.manager.TypeTracker;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeServer
extends TypeTracker {
    public static Function<TypeTracker, Type> tracker2class = new Function<TypeTracker, Type>(){

        public Type apply(TypeTracker typeTracker) {
            return typeTracker.getTarget();
        }
    };
    private final List<TypeTracker> trackers = new ArrayList<TypeTracker>();
    private final Map<String, List<List<Operation>>> operation2operations = new HashMap<String, List<List<Operation>>>();
    private final Map<String, List<Property>> property2properties = new HashMap<String, List<Property>>();
    private ReflectiveType executorType = null;
    private Map<ParameterableElement, List<WeakReference<Type>>> firstActual2specializations = null;

    protected TypeServer(PackageManager packageManager, Type primaryType) {
        super(packageManager, primaryType);
        this.trackers.add(this);
        this.initializeContents();
    }

    void addOperation(Operation pivotOperation) {
        List<Operation> overload;
        String operationName = pivotOperation.getName();
        List<List<Operation>> overloads = this.operation2operations.get(operationName);
        if (overloads == null) {
            overloads = new ArrayList<List<Operation>>();
            this.operation2operations.put(operationName, overloads);
        }
        if ((overload = this.findOverload(overloads, pivotOperation)) == null) {
            overload = new ArrayList<Operation>();
            overloads.add(overload);
        }
        if (!overload.contains(pivotOperation)) {
            overload.add(pivotOperation);
        }
    }

    void addProperty(Property pivotProperty) {
        String propertyName = pivotProperty.getName();
        List<Property> properties = this.property2properties.get(propertyName);
        if (properties == null) {
            properties = new ArrayList<Property>();
            this.property2properties.put(propertyName, properties);
        }
        if (!properties.contains(pivotProperty)) {
            properties.add(pivotProperty);
        }
    }

    public TypeClient addSecondaryType(Type secondaryType) {
        TypeClient typeClient = (TypeClient)EcoreUtil.getAdapter((List)secondaryType.eAdapters(), (Object)this.packageManager);
        if (typeClient == null) {
            typeClient = new TypeClient(this, secondaryType);
        }
        if (!this.trackers.contains(typeClient)) {
            this.trackers.add(typeClient);
        }
        return typeClient;
    }

    void addedOperation(Object object) {
        if (object instanceof Operation) {
            Operation pivotOperation = (Operation)object;
            this.addOperation(pivotOperation);
        }
    }

    void addedProperty(Object object) {
        if (object instanceof Property) {
            Property pivotProperty = (Property)object;
            this.addProperty(pivotProperty);
        }
    }

    protected Type createSpecialization(List<? extends ParameterableElement> templateArguments) {
        Type unspecializedType = this.getTarget();
        String typeName = unspecializedType.getName();
        TemplateSignature templateSignature = unspecializedType.getOwnedTemplateSignature();
        EList<TemplateParameter> templateParameters = templateSignature.getOwnedParameter();
        EClass eClass = unspecializedType.eClass();
        EFactory eFactoryInstance = eClass.getEPackage().getEFactoryInstance();
        Type specializedType = (Type)eFactoryInstance.create(eClass);
        specializedType.setName(typeName);
        TemplateBinding templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
        templateBinding.setSignature(templateSignature);
        HashMap<TemplateParameter, ParameterableElement> allBindings = new HashMap<TemplateParameter, ParameterableElement>();
        int i = 0;
        while (i < templateParameters.size()) {
            TemplateParameter formalParameter = (TemplateParameter)templateParameters.get(i);
            ParameterableElement actualType = templateArguments.get(i);
            allBindings.put(formalParameter, templateArguments.get(i));
            TemplateParameterSubstitution templateParameterSubstitution = PivotFactory.eINSTANCE.createTemplateParameterSubstitution();
            templateParameterSubstitution.setFormal(formalParameter);
            if (actualType != null && actualType.eResource() == null) {
                templateParameterSubstitution.setOwnedActual(actualType);
            } else {
                templateParameterSubstitution.setActual(actualType);
            }
            templateBinding.getParameterSubstitution().add((Object)templateParameterSubstitution);
            ++i;
        }
        specializedType.getTemplateBinding().add((Object)templateBinding);
        this.resolveSuperClasses(specializedType, unspecializedType, allBindings);
        if (specializedType instanceof CollectionType) {
            ParameterableElement templateArgument = templateArguments.get(0);
            CollectionType specializedCollectionType = (CollectionType)specializedType;
            specializedCollectionType.setElementType((Type)templateArgument);
        } else if (specializedType instanceof ClassifierType) {
            ParameterableElement templateArgument = templateArguments.get(0);
            ClassifierType specializedClassifierType = (ClassifierType)specializedType;
            specializedClassifierType.setInstanceType((Type)templateArgument);
        }
        specializedType.setUnspecializedElement(unspecializedType);
        Orphanage.getOrphanage(this.getMetaModelManager().getPivotResourceSet()).add(specializedType);
        return specializedType;
    }

    @Override
    public void dispose() {
        if (!this.trackers.isEmpty()) {
            ArrayList<TypeTracker> savedTypeTrackers = new ArrayList<TypeTracker>(this.trackers);
            this.trackers.clear();
            for (TypeTracker typeTracker : savedTypeTrackers) {
                if (!(typeTracker instanceof TypeClient)) continue;
                typeTracker.dispose();
            }
        }
        this.property2properties.clear();
        this.operation2operations.clear();
        if (this.executorType != null) {
            this.executorType.dispose();
            this.executorType = null;
        }
        super.dispose();
    }

    private List<Operation> findOverload(List<List<Operation>> overloads, Operation requiredOperation) {
        EList<Parameter> requiredParameters = requiredOperation instanceof Iteration ? ((Iteration)requiredOperation).getOwnedIterator() : requiredOperation.getOwnedParameter();
        int requiredSize = requiredParameters.size();
        for (List<Operation> overload : overloads) {
            Operation operation;
            EList<Parameter> actualParameters;
            if (overload.size() <= 0 || requiredSize != (actualParameters = (operation = overload.get(0)) instanceof Iteration ? ((Iteration)operation).getOwnedIterator() : operation.getOwnedParameter()).size()) continue;
            boolean gotIt = true;
            int i = 0;
            while (i < requiredSize) {
                Type actualType;
                TypedElement requiredParameter = (TypedElement)requiredParameters.get(i);
                TypedElement actualParameter = (TypedElement)actualParameters.get(i);
                Type requiredType = requiredParameter.getType();
                if (requiredType != (actualType = actualParameter.getType())) {
                    gotIt = false;
                    break;
                }
                ++i;
            }
            if (!gotIt) continue;
            return overload;
        }
        return null;
    }

    protected Type findSpecialization(List<WeakReference<Type>> partialSpecializations, List<? extends ParameterableElement> templateArguments) {
        int j = partialSpecializations.size();
        while (--j >= 0) {
            Type specializedType = (Type)partialSpecializations.get(j).get();
            if (specializedType == null) {
                partialSpecializations.remove(j);
                continue;
            }
            int i = 0;
            boolean gotIt = true;
            for (TemplateBinding templateBinding : specializedType.getTemplateBinding()) {
                for (TemplateParameterSubstitution parameterSubstitution : templateBinding.getParameterSubstitution()) {
                    ParameterableElement actualTemplateArgument;
                    ParameterableElement requiredTemplateArgument;
                    if (i > 0 && (requiredTemplateArgument = templateArguments.get(i)) != (actualTemplateArgument = parameterSubstitution.getActual())) {
                        gotIt = false;
                        break;
                    }
                    ++i;
                }
                if (!gotIt) break;
            }
            if (!gotIt) continue;
            return specializedType;
        }
        return null;
    }

    public synchronized Type findSpecializedType(List<? extends ParameterableElement> templateArguments) {
        TemplateSignature templateSignature = this.getTarget().getOwnedTemplateSignature();
        EList<TemplateParameter> templateParameters = templateSignature.getParameter();
        int iMax = templateParameters.size();
        if (templateArguments.size() != iMax) {
            return null;
        }
        if (this.firstActual2specializations == null) {
            return null;
        }
        ParameterableElement firstTemplateArgument = templateArguments.get(0);
        List<WeakReference<Type>> partialSpecializations = this.firstActual2specializations.get(firstTemplateArgument);
        if (partialSpecializations == null) {
            return null;
        }
        return this.findSpecialization(partialSpecializations, templateArguments);
    }

    protected PivotReflectivePackage getExecutorPackage() {
        MetaModelManager metaModelManager = this.getMetaModelManager();
        return metaModelManager.getPackageTracker(this.target.getPackage()).getPackageServer().getExecutorPackage();
    }

    public ReflectiveType getExecutorType() {
        if (this.executorType == null) {
            PivotReflectivePackage executorPackage = this.getExecutorPackage();
            this.executorType = executorPackage.getInheritance(this.target);
        }
        return this.executorType;
    }

    public Operation getOperation(Operation pivotOperation) {
        String operationName = pivotOperation.getName();
        List<List<Operation>> overloads = this.operation2operations.get(operationName);
        if (overloads == null) {
            return null;
        }
        List<Operation> overload = this.findOverload(overloads, pivotOperation);
        if (overload == null) {
            return null;
        }
        return overload.isEmpty() ? null : overload.get(0);
    }

    public Iterable<Operation> getOperations(Operation pivotOperation) {
        String operationName = pivotOperation.getName();
        List<List<Operation>> overloads = this.operation2operations.get(operationName);
        if (overloads == null) {
            return null;
        }
        return this.findOverload(overloads, pivotOperation);
    }

    public Iterable<Property> getProperties(Property pivotProperty) {
        String propertyName = pivotProperty.getName();
        return this.property2properties.get(propertyName);
    }

    public Property getProperty(String propertyName) {
        List<Property> properties = this.property2properties.get(propertyName);
        if (properties == null) {
            return null;
        }
        return properties.isEmpty() ? null : properties.get(0);
    }

    public synchronized Type getSpecializedType(List<? extends ParameterableElement> templateArguments) {
        Type specializedType;
        ParameterableElement firstTemplateArgument;
        List<WeakReference<Type>> partialSpecializations;
        TemplateSignature templateSignature = this.getTarget().getOwnedTemplateSignature();
        EList<TemplateParameter> templateParameters = templateSignature.getParameter();
        int iMax = templateParameters.size();
        if (templateArguments.size() != iMax) {
            return null;
        }
        if (this.firstActual2specializations == null) {
            this.firstActual2specializations = new HashMap<ParameterableElement, List<WeakReference<Type>>>();
        }
        if ((partialSpecializations = this.firstActual2specializations.get(firstTemplateArgument = templateArguments.get(0))) == null) {
            partialSpecializations = new ArrayList<WeakReference<Type>>();
            this.firstActual2specializations.put(firstTemplateArgument, partialSpecializations);
        }
        if ((specializedType = this.findSpecialization(partialSpecializations, templateArguments)) == null) {
            specializedType = this.createSpecialization(templateArguments);
            partialSpecializations.add(new WeakReference<Type>(specializedType));
        }
        return specializedType;
    }

    public Iterable<Type> getTypes() {
        return Iterables.transform(this.trackers, tracker2class);
    }

    @Override
    public TypeServer getTypeServer() {
        return this;
    }

    public TypeTracker getTypeTracker(Type pivotType) {
        for (TypeTracker typeTracker : this.trackers) {
            if (typeTracker.getTarget() != pivotType) continue;
            return typeTracker;
        }
        return this.addSecondaryType(pivotType);
    }

    public List<TypeTracker> getTypeTrackers() {
        return this.trackers;
    }

    @Override
    public void notifyChanged(Notification msg) {
        if (this.executorType != null && msg.getNotifier() == this.target && msg.getFeature() == PivotPackage.Literals.TYPE__SUPER_CLASS) {
            switch (msg.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: {
                    this.executorType.uninstall();
                    this.executorType = null;
                }
            }
        }
        super.notifyChanged(msg);
    }

    void removedType(Type pivotType) {
        TypeTracker typeTracker = this.packageManager.findTypeTracker(pivotType);
        if (typeTracker == this) {
            this.dispose();
        } else {
            this.trackers.remove(typeTracker);
        }
    }

    void removedClient(TypeClient classClient) {
        this.trackers.remove(classClient);
    }

    void removedOperation(Object object) {
        if (object instanceof Operation) {
            List<Operation> overload;
            Operation pivotOperation = (Operation)object;
            String operationName = pivotOperation.getName();
            List<List<Operation>> overloads = this.operation2operations.get(operationName);
            if (overloads == null) {
                overloads = new ArrayList<List<Operation>>();
                this.operation2operations.put(operationName, overloads);
            }
            if ((overload = this.findOverload(overloads, pivotOperation)) != null) {
                overload.remove(pivotOperation);
                if (overload.isEmpty()) {
                    overloads.remove(overload);
                    if (overloads.isEmpty()) {
                        this.operation2operations.remove(operationName);
                    }
                }
            }
        }
    }

    void removedProperty(Object object) {
        Property pivotProperty;
        String propertyName;
        List<Property> properties;
        if (object instanceof Property && (properties = this.property2properties.get(propertyName = (pivotProperty = (Property)object).getName())) != null) {
            properties.remove(propertyName);
            if (properties.isEmpty()) {
                this.property2properties.remove(propertyName);
            }
        }
    }

    protected void resolveSuperClasses(Type specializedClass, Type libraryClass, Map<TemplateParameter, ParameterableElement> allBindings) {
        for (Type superType : libraryClass.getSuperClass()) {
            EList superTemplateBindings = superType.getTemplateBinding();
            if (superTemplateBindings.size() > 0) {
                ArrayList<ParameterableElement> superTemplateArgumentList = new ArrayList<ParameterableElement>();
                for (TemplateBinding superTemplateBinding : superTemplateBindings) {
                    for (TemplateParameterSubstitution superParameterSubstitution : superTemplateBinding.getParameterSubstitution()) {
                        ParameterableElement superActual = superParameterSubstitution.getActual();
                        TemplateParameter superTemplateParameter = superActual.getTemplateParameter();
                        ParameterableElement actualActual = allBindings.get(superTemplateParameter);
                        superTemplateArgumentList.add(actualActual);
                    }
                }
                Type unspecializedSuperType = PivotUtil.getUnspecializedTemplateableElement(superType);
                TypeServer superTypeServer = this.getMetaModelManager().getTypeServer(unspecializedSuperType);
                Type specializedSuperType = superTypeServer.getSpecializedType(superTemplateArgumentList);
                specializedClass.getSuperClass().add((Object)specializedSuperType);
                continue;
            }
            specializedClass.getSuperClass().add((Object)superType);
        }
    }
}

