/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PackageManager;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;

public abstract class TypeTracker
implements Adapter.Internal {
    protected final PackageManager packageManager;
    protected final Type target;

    protected TypeTracker(PackageManager packageManager, Type target) {
        this.packageManager = packageManager;
        this.target = target;
        target.eAdapters().add((Object)this);
        packageManager.addTypeTracker(target, this);
    }

    public void dispose() {
        this.packageManager.removeTypeTracker(this);
        this.target.eAdapters().remove((Object)this);
    }

    public final MetaModelManager getMetaModelManager() {
        return this.packageManager.getMetaModelManager();
    }

    public final PackageManager getPackageManager() {
        return this.packageManager;
    }

    public Type getPrimaryType() {
        TypeServer typeServer = this.getTypeServer();
        return typeServer != null ? typeServer.getTarget() : null;
    }

    public final Type getTarget() {
        return this.target;
    }

    public abstract TypeServer getTypeServer();

    protected void initializeContents() {
        TypeServer typeServer = this.getTypeServer();
        for (Operation pivotOperation : this.target.getOwnedOperation()) {
            typeServer.addOperation(pivotOperation);
        }
        for (Property pivotProperty : this.target.getOwnedAttribute()) {
            typeServer.addProperty(pivotProperty);
        }
    }

    public final boolean isAdapterForType(Object type) {
        return type == this.packageManager;
    }

    public void notifyChanged(Notification notification) {
        block19: {
            Object feature;
            int eventType;
            TypeServer typeServer;
            block18: {
                typeServer = this.getTypeServer();
                if (typeServer == null) {
                    return;
                }
                eventType = notification.getEventType();
                feature = notification.getFeature();
                if (feature != PivotPackage.Literals.TYPE__OWNED_OPERATION) break block18;
                switch (eventType) {
                    case 3: {
                        Object value = notification.getNewValue();
                        typeServer.addedOperation(value);
                        break;
                    }
                    case 5: {
                        List values = (List)notification.getNewValue();
                        for (Object value : values) {
                            typeServer.addedOperation(value);
                        }
                        break block19;
                    }
                    case 4: {
                        Object value = notification.getOldValue();
                        typeServer.removedOperation(value);
                        break;
                    }
                    case 6: {
                        List values = (List)notification.getOldValue();
                        for (Object value : values) {
                            typeServer.removedOperation(value);
                        }
                    }
                }
                break block19;
            }
            if (feature == PivotPackage.Literals.TYPE__OWNED_ATTRIBUTE) {
                switch (eventType) {
                    case 3: {
                        Object value = notification.getNewValue();
                        typeServer.addedProperty(value);
                        break;
                    }
                    case 5: {
                        List values = (List)notification.getNewValue();
                        for (Object value : values) {
                            typeServer.addedProperty(value);
                        }
                        break;
                    }
                    case 4: {
                        Object value = notification.getOldValue();
                        typeServer.removedProperty(value);
                        break;
                    }
                    case 6: {
                        List values = (List)notification.getOldValue();
                        for (Object value : values) {
                            typeServer.removedProperty(value);
                        }
                        break;
                    }
                }
            }
        }
    }

    public void setTarget(Notifier newTarget) {
        assert (this.target == newTarget);
    }

    public String toString() {
        return String.valueOf(this.target);
    }

    public void unsetTarget(Notifier oldTarget) {
        assert (this.target == oldTarget);
    }
}

