/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.uml;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotConstants;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.uml.UML2PivotDeclarationSwitch;
import org.eclipse.ocl.examples.pivot.uml.UML2PivotReferenceSwitch;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.AliasAdapter;
import org.eclipse.ocl.examples.pivot.utilities.External2Pivot;
import org.eclipse.ocl.examples.pivot.utilities.PivotObjectImpl;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UML2Pivot
extends AbstractConversion
implements External2Pivot,
PivotConstants {
    private static final Logger logger = Logger.getLogger(UML2Pivot.class);
    private static final String OCL_STANDARD_LIBRARY_NS_URI = "http://www.eclipse.org/ocl/1.1.0/oclstdlib.uml";
    private Map<EModelElement, Element> createMap = new HashMap<EModelElement, Element>();
    private Set<EModelElement> referencers = new HashSet<EModelElement>();
    private Set<UML2Pivot> allConverters = new HashSet<UML2Pivot>();
    private List<Resource.Diagnostic> errors = null;
    protected final Resource umlResource;
    protected Package pivotRoot = null;
    protected final UML2PivotDeclarationSwitch declarationPass = new UML2PivotDeclarationSwitch(this);
    protected final UML2PivotReferenceSwitch referencePass = new UML2PivotReferenceSwitch(this);

    public static UML2Pivot getAdapter(Resource resource, MetaModelManager metaModelManager) {
        if (resource == null) {
            return null;
        }
        EList eAdapters = resource.eAdapters();
        UML2Pivot adapter = PivotUtil.getAdapter(UML2Pivot.class, (Notifier)resource);
        if (adapter != null) {
            return adapter;
        }
        adapter = new UML2Pivot(resource, metaModelManager);
        eAdapters.add(adapter);
        return adapter;
    }

    public static Package importFromUML(MetaModelManager metaModelManager, String alias, Resource ecoreResource) {
        if (ecoreResource == null) {
            return null;
        }
        UML2Pivot conversion = UML2Pivot.getAdapter(ecoreResource, metaModelManager);
        return conversion.getPivotRoot();
    }

    public static String initialize(ResourceSet resourceSet) {
        UMLResourcesUtil.init((ResourceSet)resourceSet);
        String oclLocation = System.getProperty("org.eclipse.ocl.uml");
        if (oclLocation == null) {
            return "'org.eclipse.ocl.uml' property not defined; use the launch configuration to define it";
        }
        String resourcesLocation = System.getProperty("org.eclipse.uml2.uml.resources");
        if (resourcesLocation == null) {
            return "'org.eclipse.uml2.uml.resources' property not defined; use the launch configuration to define it";
        }
        Map uriMap = resourceSet != null ? resourceSet.getURIConverter().getURIMap() : URIConverter.URI_MAP;
        uriMap.put(URI.createURI((String)OCL_STANDARD_LIBRARY_NS_URI), URI.createFileURI((String)(String.valueOf(oclLocation) + "/model/oclstdlib.uml")));
        uriMap.put(URI.createURI((String)"pathmap://UML_PROFILES/"), URI.createFileURI((String)(String.valueOf(resourcesLocation) + "/profiles/")));
        uriMap.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), URI.createFileURI((String)(String.valueOf(resourcesLocation) + "/metamodels/")));
        uriMap.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), URI.createFileURI((String)(String.valueOf(resourcesLocation) + "/libraries/")));
        return null;
    }

    public static Element importFromUML(MetaModelManager metaModelManager, String alias, EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource ecoreResource = eObject.eResource();
        UML2Pivot conversion = UML2Pivot.getAdapter(ecoreResource, metaModelManager);
        Package pivotRoot = conversion.getPivotRoot();
        if (pivotRoot == null) {
            return null;
        }
        return conversion.createMap.get(eObject);
    }

    public UML2Pivot(Resource umlResource, MetaModelManager metaModelManager) {
        super(metaModelManager);
        this.umlResource = umlResource;
        metaModelManager.addExternalResource(this);
        metaModelManager.addListener(this);
    }

    public void addCreated(EModelElement umlElement, Element pivotElement) {
        this.createMap.put(umlElement, pivotElement);
    }

    protected void copyAnnotatedElement(NamedElement pivotElement, EModelElement umlElement, List<EAnnotation> excludedAnnotations) {
        EList<Annotation> pivotAnnotations = pivotElement.getOwnedAnnotation();
        for (EAnnotation eAnnotation : umlElement.getEAnnotations()) {
            if (excludedAnnotations != null && excludedAnnotations.contains(eAnnotation)) continue;
            Annotation pivotAnnotation = (Annotation)this.declarationPass.doSwitch((EObject)eAnnotation);
            pivotAnnotations.add(pivotAnnotation);
        }
    }

    protected void copyModelElement(Element pivotElement, EModelElement umlElement) {
        this.setOriginalMapping(pivotElement, umlElement);
    }

    protected void copyMultiplicityElement(TypedMultiplicityElement pivotElement, MultiplicityElement umlMultiplicityElement) {
        int lower = umlMultiplicityElement.getLower();
        int upper = umlMultiplicityElement.getUpper();
        pivotElement.setLower(BigInteger.valueOf(lower));
        pivotElement.setUpper(BigInteger.valueOf(upper));
        pivotElement.setIsOrdered(umlMultiplicityElement.isOrdered());
        pivotElement.setIsUnique(umlMultiplicityElement.isUnique());
    }

    protected void copyNamedElement(NamedElement pivotElement, org.eclipse.uml2.uml.NamedElement umlNamedElement) {
        this.copyModelElement(pivotElement, (EModelElement)umlNamedElement);
        String name = umlNamedElement.getName();
        pivotElement.setName(name);
    }

    protected void copyProperty(Property pivotElement, org.eclipse.uml2.uml.Property umlProperty, List<EAnnotation> excludedAnnotations) {
        EAnnotation oclAnnotation = OCLCommon.getDelegateAnnotation((EModelElement)umlProperty);
        if (oclAnnotation != null) {
            excludedAnnotations = new ArrayList<EAnnotation>();
            excludedAnnotations.add(oclAnnotation);
            EList<Constraint> constraints = pivotElement.getOwnedRule();
            for (Map.Entry entry : oclAnnotation.getDetails().entrySet()) {
                Constraint constraint = PivotFactory.eINSTANCE.createConstraint();
                String key = (String)entry.getKey();
                if (key.equals("derivation")) {
                    constraint.setStereotype("derivation");
                } else if (key.equals("initial")) {
                    constraint.setStereotype("initial");
                } else {
                    this.error("Unsupported feature constraint " + key);
                    constraint = null;
                }
                if (constraint == null) continue;
                String value = (String)entry.getValue();
                OpaqueExpression specification = PivotFactory.eINSTANCE.createOpaqueExpression();
                specification.getBody().add((Object)value);
                specification.getLanguage().add((Object)"OCL");
                constraint.setSpecification(specification);
                constraints.add(constraint);
            }
        }
        this.copyTypedElement(pivotElement, (TypedElement)umlProperty, excludedAnnotations);
        this.copyMultiplicityElement(pivotElement, (MultiplicityElement)umlProperty);
        pivotElement.setIsReadOnly(umlProperty.isReadOnly());
        pivotElement.setIsDerived(umlProperty.isDerived());
    }

    protected void copyTypedElement(TypedMultiplicityElement pivotElement, TypedElement umlTypedElement, List<EAnnotation> excludedAnnotations) {
        this.copyNamedElement(pivotElement, (org.eclipse.uml2.uml.NamedElement)umlTypedElement);
        this.copyAnnotatedElement(pivotElement, (EModelElement)umlTypedElement, excludedAnnotations);
        org.eclipse.uml2.uml.Type umlType = umlTypedElement.getType();
        if (umlType != null) {
            this.queueReference((EModelElement)umlTypedElement);
        }
    }

    public void dispose() {
        this.metaModelManager.removeExternalResource(this);
        this.getTarget().eAdapters().remove((Object)this);
    }

    protected void error(String message) {
        if (this.errors == null) {
            this.errors = new ArrayList<Resource.Diagnostic>();
        }
        this.errors.add((Resource.Diagnostic)new XMIException(message));
    }

    public <T extends Element> T getCreated(java.lang.Class<T> requiredClass, EObject eObject) {
        Element element = this.createMap.get(eObject);
        if (element == null) {
            return null;
        }
        if (!requiredClass.isAssignableFrom(element.getClass())) {
            logger.error((Object)("Ecore " + element.getClass().getName() + "' element is not a '" + requiredClass.getName() + "'"));
            return null;
        }
        Element castElement = element;
        return (T)castElement;
    }

    protected MetaModelManager getMetaModelManager() {
        return this.metaModelManager;
    }

    public Type getPivotType(EObject eObject) {
        Element pivotElement = this.createMap.get(eObject);
        if (pivotElement == null) {
            UML2Pivot converter;
            Resource resource = eObject.eResource();
            if (resource != this.umlResource && resource != null && this.allConverters.add(converter = UML2Pivot.getAdapter(resource, this.metaModelManager))) {
                converter.getPivotRoot();
                for (Map.Entry<EModelElement, Element> entry : converter.createMap.entrySet()) {
                    this.createMap.put(entry.getKey(), entry.getValue());
                }
            }
            pivotElement = this.createMap.get(eObject);
        }
        if (pivotElement == null) {
            this.error("Unresolved " + eObject);
        } else if (!(pivotElement instanceof Type)) {
            this.error("Incompatible " + eObject);
        } else {
            return (Type)pivotElement;
        }
        return null;
    }

    public Package getPivotRoot() {
        if (this.pivotRoot == null) {
            Resource pivotResource = this.importObjects((Collection<EObject>)this.umlResource.getContents(), this.umlResource.getURI());
            AliasAdapter ecoreAdapter = AliasAdapter.findAdapter(this.umlResource);
            if (ecoreAdapter != null) {
                Map<EObject, String> ecoreAliasMap = ecoreAdapter.getAliasMap();
                AliasAdapter pivotAdapter = AliasAdapter.getAdapter(pivotResource);
                Map<EObject, String> pivotAliasMap = pivotAdapter.getAliasMap();
                for (EObject eObject : ecoreAliasMap.keySet()) {
                    String alias = ecoreAliasMap.get(eObject);
                    Element element = this.createMap.get(eObject);
                    pivotAliasMap.put(element, alias);
                }
            }
            this.metaModelManager.installResource(pivotResource);
        }
        return this.pivotRoot;
    }

    @Override
    public Resource getResource() {
        return this.umlResource;
    }

    public Notifier getTarget() {
        return this.umlResource;
    }

    @Override
    public URI getURI() {
        return this.umlResource.getURI();
    }

    public Resource importObjects(Collection<EObject> ecoreContents, URI ecoreURI) {
        Resource pivotResource = this.metaModelManager.createResource(ecoreURI, "org.eclipse.ocl.examples.pivot");
        this.pivotRoot = this.metaModelManager.createModel(ecoreURI.lastSegment(), null);
        pivotResource.getContents().add((Object)this.pivotRoot);
        EList<Package> packages = this.pivotRoot.getNestedPackage();
        for (EObject eObject : ecoreContents) {
            Object pivotElement = this.declarationPass.doInPackageSwitch(eObject);
            if (pivotElement instanceof Package) {
                packages.add((Package)pivotElement);
                continue;
            }
            this.error("Bad ecore content");
        }
        for (EObject eObject : this.referencers) {
            this.referencePass.doInPackageSwitch(eObject);
        }
        if (this.errors != null) {
            pivotResource.getErrors().addAll(this.errors);
        }
        return pivotResource;
    }

    @Override
    public boolean isAdapterFor(MetaModelManager metaModelManager) {
        return this.metaModelManager == metaModelManager;
    }

    public boolean isAdapterForType(Object type) {
        return type == UML2Pivot.class;
    }

    @Override
    public void metaModelManagerDisposed(MetaModelManager metaModelManager) {
        this.dispose();
    }

    public void notifyChanged(Notification notification) {
    }

    public void queueReference(EModelElement umlElement) {
        this.referencers.add(umlElement);
    }

    protected <T extends Element> T refreshElement(java.lang.Class<T> pivotClass, EClass pivotEClass, org.eclipse.uml2.uml.Element umlElement) {
        EFactory eFactoryInstance = pivotEClass.getEPackage().getEFactoryInstance();
        EObject pivotElement = eFactoryInstance.create(pivotEClass);
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException();
        }
        Element castElement = (Element)pivotElement;
        return (T)castElement;
    }

    protected <T extends NamedElement> T refreshNamedElement(java.lang.Class<T> pivotClass, EClass pivotEClass, org.eclipse.uml2.uml.NamedElement umlNamedElement) {
        EFactory eFactoryInstance = pivotEClass.getEPackage().getEFactoryInstance();
        EObject pivotElement = eFactoryInstance.create(pivotEClass);
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException();
        }
        NamedElement castElement = (NamedElement)pivotElement;
        castElement.setName(umlNamedElement.getName());
        return (T)castElement;
    }

    protected Type resolveDataType(EGenericType eGenericType) {
        assert (eGenericType.getETypeArguments().isEmpty());
        EDataType eClassifier = (EDataType)eGenericType.getEClassifier();
        Type pivotType = null;
        if (eClassifier.getEPackage() == EcorePackage.eINSTANCE) {
            if (eClassifier == EcorePackage.Literals.EBOOLEAN) {
                pivotType = this.metaModelManager.getBooleanType();
            } else if (eClassifier == EcorePackage.Literals.EBIG_INTEGER) {
                pivotType = this.metaModelManager.getIntegerType();
            } else if (eClassifier == EcorePackage.Literals.EBIG_DECIMAL) {
                pivotType = this.metaModelManager.getRealType();
            } else if (eClassifier == EcorePackage.Literals.ESTRING) {
                pivotType = this.metaModelManager.getStringType();
            }
        }
        if (pivotType == null) {
            pivotType = this.getPivotType((EObject)eClassifier);
        }
        return pivotType;
    }

    protected Type resolveSimpleType(EGenericType eGenericType) {
        assert (eGenericType.getETypeArguments().isEmpty());
        EClassifier eClassifier = eGenericType.getEClassifier();
        Type pivotType = this.getPivotType((EObject)eClassifier);
        return pivotType;
    }

    protected Type resolveType(org.eclipse.uml2.uml.Type umlType) {
        Type pivotType = this.getCreated(Type.class, (EObject)umlType);
        if (pivotType != null) {
            return pivotType;
        }
        return pivotType;
    }

    protected Type resolveTypeParameter(EGenericType eGenericType) {
        EClassifier eClassifier = eGenericType.getEClassifier();
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        EList eTypeArguments = eGenericType.getETypeArguments();
        assert (eClassifier == null);
        assert (eTypeArguments.isEmpty());
        Type pivotType = this.getCreated(Type.class, (EObject)eTypeParameter);
        return pivotType;
    }

    protected Type resolveWildcardType(EGenericType eGenericType) {
        EObject eContainer;
        List list;
        int index;
        assert (eGenericType.getETypeArguments().isEmpty());
        assert (eGenericType.getEClassifier() == null);
        EClassifier eClassifier = eGenericType.getERawType();
        assert (eClassifier == EcorePackage.Literals.EJAVA_OBJECT);
        Class pivotElement = PivotFactory.eINSTANCE.createClass();
        String name = "wildcard";
        EReference eFeature = eGenericType.eContainmentFeature();
        if (eFeature != null && eFeature.isMany() && (index = (list = (List)(eContainer = eGenericType.eContainer()).eGet(eGenericType.eContainingFeature())).indexOf(eGenericType)) != 0) {
            name = String.valueOf(name) + index;
        }
        pivotElement.setName(name);
        return pivotElement;
    }

    protected void setOriginalMapping(Element pivotElement, EModelElement umlElement) {
        ((PivotObjectImpl)((Object)pivotElement)).setTarget((Notifier)umlElement);
        this.addCreated(umlElement, pivotElement);
    }

    public void setTarget(Notifier newTarget) {
        assert (newTarget == this.umlResource);
    }

    public void unsetTarget(Notifier oldTarget) {
        assert (oldTarget == this.umlResource);
    }
}

