/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveInstances<T> {
    protected final Class<T> liveClass;
    private Map<T, Object> instances = new WeakHashMap<T, Object>();

    public LiveInstances(Class<T> liveClass) {
        this.liveClass = liveClass;
    }

    public void add(T anInstance) {
        this.instances.put(anInstance, null);
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " Add " + this.liveClass.getSimpleName() + "@" + Integer.toHexString(anInstance.hashCode()));
    }

    public void remove(T anInstance) {
        this.instances.remove(anInstance);
        System.out.println(String.valueOf(Thread.currentThread().getName()) + " Remove " + this.liveClass.getSimpleName() + "@" + Integer.toHexString(anInstance.hashCode()));
    }

    public void show() {
        if (this.instances.isEmpty()) {
            System.out.println("No " + this.liveClass.getSimpleName() + " instances live");
        } else {
            StringBuilder s = new StringBuilder();
            s.append("Live instances of " + this.liveClass.getSimpleName());
            for (T instance : this.instances.keySet()) {
                s.append("\n\t");
                s.append("@" + Integer.toHexString(instance.hashCode()));
            }
            System.out.println(s.toString());
        }
    }
}

