/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.library;

import java.util.Iterator;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluationEnvironment;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidEvaluationException;
import org.eclipse.ocl.examples.domain.library.AbstractIterationManager;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.NullValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.osgi.util.NLS;

public abstract class EvaluatorIterationManager
extends AbstractIterationManager {
    protected final CollectionValue collectionValue;
    protected final DomainExpression body;
    protected final DomainTypedElement accumulatorVariable;
    private Value accumulatorValue;

    protected static ValueIterator[] createIterators(DomainTypedElement[] referredIterators, DomainEvaluator evaluator, CollectionValue collectionValue) {
        int iMax = referredIterators.length;
        ValueIterator[] iterators = new ValueIterator[iMax];
        int i = 0;
        while (i < iMax) {
            DomainTypedElement referredIterator = referredIterators[i];
            ValueIterator valueIterator = new ValueIterator(evaluator, collectionValue, referredIterator);
            if (!valueIterator.hasCurrent()) {
                return null;
            }
            iterators[i] = valueIterator;
            ++i;
        }
        return iterators;
    }

    public EvaluatorIterationManager(DomainEvaluator evaluator, DomainExpression body, CollectionValue collectionValue, DomainTypedElement accumulatorVariable, Value accumulatorValue) {
        super(evaluator);
        this.collectionValue = collectionValue;
        this.body = body;
        this.accumulatorVariable = accumulatorVariable;
        this.accumulatorValue = accumulatorValue;
        if (accumulatorVariable != null) {
            this.getEvaluationEnvironment().add(accumulatorVariable, accumulatorValue);
        }
    }

    public EvaluatorIterationManager(EvaluatorIterationManager iterationManager, CollectionValue collectionValue) {
        super(iterationManager.evaluator);
        this.body = iterationManager.body;
        this.collectionValue = collectionValue;
        this.accumulatorValue = iterationManager.accumulatorValue;
        this.accumulatorVariable = iterationManager.accumulatorVariable;
    }

    public Value getAccumulatorValue() {
        return this.accumulatorValue;
    }

    public Value evaluateBody() {
        return this.evaluator.evaluate(this.body);
    }

    public CollectionValue getCollectionValue() {
        return this.collectionValue;
    }

    public DomainEvaluationEnvironment getEvaluationEnvironment() {
        return this.evaluator.getEvaluationEnvironment();
    }

    public NullValue throwInvalidEvaluation(String message, Object ... bindings) throws InvalidEvaluationException {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        throw new InvalidEvaluationException(this.getEvaluationEnvironment(), boundMessage, null, null, null);
    }

    public String toString() {
        return this.body.toString();
    }

    public Value updateBody() {
        Value bodyVal;
        this.accumulatorValue = bodyVal = this.evaluateBody();
        if (this.accumulatorVariable != null) {
            this.getEvaluationEnvironment().replace(this.accumulatorVariable, this.accumulatorValue);
        }
        return null;
    }

    protected static class ValueIterator {
        private final DomainEvaluationEnvironment evaluationEnvironment;
        private final CollectionValue collectionValue;
        private final DomainTypedElement variable;
        private Iterator<Value> javaIter;
        private Value value = null;

        public ValueIterator(DomainEvaluator evaluator, CollectionValue collectionValue, DomainTypedElement variable) {
            this.evaluationEnvironment = evaluator.getEvaluationEnvironment();
            this.collectionValue = collectionValue;
            this.variable = variable;
            this.reset();
        }

        public Value get() {
            return this.value;
        }

        public boolean hasCurrent() {
            return this.value != null;
        }

        public Value next() {
            if (!this.javaIter.hasNext()) {
                this.value = null;
            } else {
                this.value = this.javaIter.next();
                this.evaluationEnvironment.replace(this.variable, this.value);
            }
            return this.value;
        }

        public Value reset() {
            this.javaIter = this.collectionValue.iterator();
            return this.next();
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.variable)) + " = " + String.valueOf(this.value);
        }
    }
}

