/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.types;

import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.types.AbstractSpecializedType;

public class AbstractCollectionType
extends AbstractSpecializedType
implements DomainCollectionType {
    protected final DomainType elementType;

    public AbstractCollectionType(DomainStandardLibrary standardLibrary, String name, DomainType containerType, DomainType elementType) {
        super(standardLibrary, name, containerType);
        this.elementType = elementType;
    }

    public boolean conformsTo(DomainStandardLibrary standardLibrary, DomainType type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof DomainCollectionType)) {
            return false;
        }
        return standardLibrary.conformsToCollectionType(this, (DomainCollectionType)type);
    }

    public DomainType getCommonType(DomainStandardLibrary standardLibrary, DomainType type) {
        if (!(type instanceof AbstractCollectionType)) {
            return standardLibrary.getOclAnyType();
        }
        AbstractCollectionType thatClass = (AbstractCollectionType)type;
        DomainType commonContainerClass = this.containerType;
        DomainType commonElementClass = this.elementType.getCommonType(standardLibrary, thatClass.elementType);
        if (commonContainerClass == this.containerType && commonElementClass == this.elementType) {
            return this;
        }
        if (commonContainerClass == thatClass.containerType && commonElementClass == thatClass.elementType) {
            return thatClass;
        }
        if (commonContainerClass.isOrdered()) {
            if (commonContainerClass.isUnique()) {
                return standardLibrary.getOrderedSetType(commonElementClass);
            }
            return standardLibrary.getSequenceType(commonElementClass);
        }
        if (commonContainerClass.isUnique()) {
            return standardLibrary.getSetType(commonElementClass);
        }
        return standardLibrary.getBagType(commonElementClass);
    }

    public DomainType getElementType() {
        return this.elementType;
    }

    public boolean isEqualTo(DomainStandardLibrary standardLibrary, DomainType type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof DomainCollectionType)) {
            return false;
        }
        return standardLibrary.isEqualToCollectionType(this, (DomainCollectionType)type);
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.containerType)) + "(" + String.valueOf(this.elementType) + ")";
    }
}

