/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.types;

import java.util.Iterator;
import org.eclipse.ocl.examples.domain.elements.DomainFragment;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.utilities.IndexableIterable;
import org.eclipse.ocl.examples.domain.values.ObjectValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

public abstract class AbstractInheritance
implements DomainInheritance {
    public static final int ORDERED = 1;
    public static final int UNIQUE = 2;
    protected final String name;
    protected final DomainPackage evaluationPackage;
    protected final int flags;

    public AbstractInheritance(String name, DomainPackage evaluationPackage, int flags) {
        this.name = name;
        this.evaluationPackage = evaluationPackage;
        this.flags = flags;
    }

    public boolean conformsTo(DomainStandardLibrary standardLibrary, DomainType type) {
        DomainInheritance thatInheritance = type.getInheritance(standardLibrary);
        if (this == thatInheritance) {
            return true;
        }
        return thatInheritance.isSuperInheritanceOf(standardLibrary, this);
    }

    public ObjectValue createInstance(ValueFactory valueFactory) {
        throw new UnsupportedOperationException();
    }

    public Value createInstance(ValueFactory valueFactory, String value) {
        throw new UnsupportedOperationException();
    }

    public DomainInheritance getCommonInheritance(DomainInheritance thatInheritance) {
        if (this == thatInheritance) {
            return this;
        }
        int thatDepth = thatInheritance.getDepth();
        if (thatDepth == 1 && thatInheritance.isUndefined()) {
            return this;
        }
        int thisDepth = this.getDepth();
        int staticDepth = Math.min(thisDepth, thatDepth);
        while (staticDepth > 0) {
            int iMax = this.getIndex(staticDepth + 1);
            int jMax = thatInheritance.getIndex(staticDepth + 1);
            int i = this.getIndex(staticDepth);
            while (i < iMax) {
                DomainInheritance thisBaseInheritance = this.getFragment(i).getBaseInheritance();
                int j = thatInheritance.getIndex(staticDepth);
                while (j < jMax) {
                    DomainInheritance thatBaseInheritance = thatInheritance.getFragment(j).getBaseInheritance();
                    if (thisBaseInheritance == thatBaseInheritance) {
                        return thisBaseInheritance;
                    }
                    ++j;
                }
                ++i;
            }
            --staticDepth;
        }
        return this.getFragment(0).getDerivedInheritance();
    }

    public DomainType getCommonType(DomainStandardLibrary standardLibrary, DomainType type) {
        AbstractInheritance firstInheritance = this;
        DomainInheritance secondInheritance = type.getInheritance(standardLibrary);
        DomainInheritance commonInheritance = firstInheritance.getCommonInheritance(secondInheritance);
        return commonInheritance;
    }

    public DomainFragment getFragment(DomainInheritance thatInheritance) {
        int staticDepth = thatInheritance.getDepth();
        if (staticDepth <= this.getDepth()) {
            int iMax = this.getIndex(staticDepth + 1);
            int i = this.getIndex(staticDepth);
            while (i < iMax) {
                DomainFragment fragment = this.getFragment(i);
                if (fragment.getBaseInheritance() == thatInheritance) {
                    return fragment;
                }
                ++i;
            }
        }
        return null;
    }

    public DomainInheritance getInheritance(DomainStandardLibrary standardLibrary) {
        return this;
    }

    public final String getName() {
        return this.name;
    }

    public DomainType getNormalizedType(DomainStandardLibrary standardLibrary) {
        return this;
    }

    protected DomainInheritance getOclAnyInheritance() {
        DomainStandardLibrary standardLibrary = this.getStandardLibrary();
        DomainType oclAnyType = standardLibrary.getOclAnyType();
        return oclAnyType.getInheritance(standardLibrary);
    }

    public final DomainPackage getPackage() {
        return this.evaluationPackage;
    }

    public boolean isEqualTo(DomainStandardLibrary standardLibrary, DomainType type) {
        return this == type;
    }

    public boolean isEqualToUnspecializedType(DomainStandardLibrary standardLibrary, DomainType type) {
        return this == type;
    }

    public boolean isOrdered() {
        return (this.flags & 1) != 0;
    }

    public boolean isSubInheritanceOf(DomainInheritance thatInheritance) {
        return this.getFragment(thatInheritance) != null;
    }

    public boolean isSuperInheritanceOf(DomainStandardLibrary standardLibrary, DomainInheritance thatInheritance) {
        return thatInheritance.getFragment(this) != null;
    }

    public boolean isUndefined() {
        return false;
    }

    public boolean isUnique() {
        return (this.flags & 2) != 0;
    }

    public LibraryFeature lookupImplementation(DomainStandardLibrary standardLibrary, DomainOperation staticOperation) {
        this.getDepth();
        DomainInheritance staticInheritance = staticOperation.getInheritance(standardLibrary);
        int staticDepth = staticInheritance.getDepth();
        if (staticDepth + 1 < this.getIndexes()) {
            int iMax = this.getIndex(staticDepth + 1);
            int i = this.getIndex(staticDepth);
            while (i < iMax) {
                DomainFragment fragment = this.getFragment(i);
                if (fragment.getBaseInheritance() == staticInheritance) {
                    return fragment.getImplementation(staticOperation);
                }
                ++i;
            }
        }
        return staticOperation.getImplementation();
    }

    public DomainOperation lookupLocalOperation(DomainStandardLibrary standardLibrary, String operationName, DomainInheritance ... argumentTypes) {
        for (DomainOperation domainOperation : this.getLocalOperations()) {
            IndexableIterable<? extends DomainType> firstParameterTypes;
            int iMax;
            if (!domainOperation.getName().equals(operationName) || (iMax = (firstParameterTypes = domainOperation.getParameterType()).size()) != argumentTypes.length) continue;
            int i = 0;
            while (i < iMax) {
                DomainInheritance secondParameterType;
                DomainType firstParameterType = firstParameterTypes.get(i);
                if (!firstParameterType.isEqualTo(standardLibrary, secondParameterType = argumentTypes[i])) break;
                ++i;
            }
            if (i < iMax) continue;
            return domainOperation;
        }
        return null;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.evaluationPackage)) + "::" + String.valueOf(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FragmentIterable
    implements IndexableIterable<DomainFragment> {
        private final DomainFragment[] array;
        private final int firstIndex;
        private final int lastIndex;

        public FragmentIterable(DomainFragment[] array) {
            this.array = array;
            this.firstIndex = 0;
            this.lastIndex = array.length;
        }

        public FragmentIterable(DomainFragment[] array, int firstIndex, int lastIndex) {
            this.array = array;
            this.firstIndex = firstIndex;
            this.lastIndex = lastIndex;
        }

        @Override
        public DomainFragment get(int index) {
            return this.array[this.firstIndex + index];
        }

        @Override
        public java.util.Iterator<DomainFragment> iterator() {
            return new Iterator();
        }

        @Override
        public int size() {
            return this.lastIndex - this.firstIndex;
        }

        public String toString() {
            StringBuilder s = null;
            int i = this.firstIndex;
            while (i < this.lastIndex) {
                if (s == null) {
                    s = new StringBuilder();
                    s.append("[");
                } else {
                    s.append(", ");
                }
                s.append(this.array[i]);
                ++i;
            }
            if (s == null) {
                return "";
            }
            s.append("]");
            return s.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class Iterator
        implements java.util.Iterator<DomainFragment> {
            private int index;

            protected Iterator() {
                this.index = FragmentIterable.this.firstIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index < FragmentIterable.this.lastIndex;
            }

            @Override
            public DomainFragment next() {
                return FragmentIterable.this.array[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

