/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainEnumeration;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainLambdaType;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainTupleType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.types.AbstractTuplePart;

public abstract class AbstractStandardLibrary
implements DomainStandardLibrary {
    private Map<String, Map<DomainType, DomainTypedElement>> tupleParts = null;

    public boolean conformsToCollectionType(DomainCollectionType firstCollectionType, DomainCollectionType secondCollectionType) {
        DomainType secondElementType;
        DomainType firstElementType;
        DomainType secondContainerType;
        DomainType firstContainerType = firstCollectionType.getContainerType();
        if (firstContainerType != (secondContainerType = secondCollectionType.getContainerType())) {
            if (secondContainerType == null) {
                return false;
            }
            DomainInheritance firstInheritance = firstCollectionType.getInheritance(this);
            DomainInheritance secondInheritance = secondCollectionType.getInheritance(this);
            if (!secondInheritance.isSuperInheritanceOf(this, firstInheritance)) {
                return false;
            }
        }
        if ((firstElementType = firstCollectionType.getElementType()) != (secondElementType = secondCollectionType.getElementType())) {
            if (firstElementType == null) {
                return false;
            }
            if (!firstElementType.conformsTo(this, secondElementType)) {
                return false;
            }
        }
        return true;
    }

    public boolean conformsToLambdaType(DomainLambdaType firstLambdaType, DomainLambdaType secondLambdaType) {
        throw new UnsupportedOperationException();
    }

    public boolean conformsToTupleType(DomainTupleType firstTupleType, DomainTupleType secondTupleType) {
        if (this.isEqualToTupleType(firstTupleType, secondTupleType)) {
            return true;
        }
        if (secondTupleType == null) {
            return false;
        }
        DomainInheritance firstInheritance = firstTupleType.getInheritance(this);
        DomainInheritance secondInheritance = secondTupleType.getInheritance(this);
        return firstInheritance.isSuperInheritanceOf(this, secondInheritance);
    }

    public void dispose() {
        this.tupleParts = null;
    }

    public DomainCollectionType getCollectionType(DomainCollectionType containerType, DomainType elementType) {
        boolean isOrdered = containerType.isOrdered();
        boolean isUnique = containerType.isUnique();
        if (isOrdered) {
            if (isUnique) {
                return this.getOrderedSetType(elementType);
            }
            return this.getSequenceType(elementType);
        }
        if (isUnique) {
            return this.getSetType(elementType);
        }
        return this.getBagType(elementType);
    }

    public DomainEnumeration getEnumeration(Enumerator enumerator) {
        throw new UnsupportedOperationException();
    }

    public DomainType getMetaType(DomainType instanceType) {
        throw new UnsupportedOperationException();
    }

    public DomainTypedElement getTuplePart(String name, DomainType type) {
        DomainTypedElement tupleProperty;
        Map<DomainType, DomainTypedElement> typeMap;
        if (this.tupleParts == null) {
            this.tupleParts = new HashMap<String, Map<DomainType, DomainTypedElement>>();
        }
        if ((typeMap = this.tupleParts.get(name)) == null) {
            typeMap = new HashMap<DomainType, DomainTypedElement>();
            this.tupleParts.put(name, typeMap);
        }
        if ((tupleProperty = typeMap.get(type)) == null) {
            tupleProperty = new AbstractTuplePart(type, name);
            typeMap.put(type, tupleProperty);
        }
        return tupleProperty;
    }

    public DomainTupleType getTupleType(DomainTypedElement ... parts) {
        ArrayList<DomainTypedElement> partsList = new ArrayList<DomainTypedElement>(parts.length);
        DomainTypedElement[] domainTypedElementArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            DomainTypedElement part = domainTypedElementArray[n2];
            partsList.add(part);
            ++n2;
        }
        return this.getTupleType(partsList);
    }

    public DomainType getType(DomainElement element) {
        if (element instanceof EObject) {
            return this.getType((EClassifier)((EObject)element).eClass());
        }
        throw new UnsupportedOperationException();
    }

    public boolean isEqualToCollectionType(DomainCollectionType firstCollectionType, DomainCollectionType secondCollectionType) {
        DomainType secondElementType;
        DomainType firstElementType;
        DomainType secondContainerType;
        DomainType firstContainerType = firstCollectionType.getContainerType();
        if (firstContainerType != (secondContainerType = secondCollectionType.getContainerType())) {
            if (firstContainerType == null) {
                return false;
            }
            if (!firstContainerType.isEqualToUnspecializedType(this, secondContainerType)) {
                return false;
            }
        }
        if ((firstElementType = firstCollectionType.getElementType()) != (secondElementType = secondCollectionType.getElementType())) {
            if (firstElementType == null) {
                return false;
            }
            if (!firstElementType.isEqualTo(this, secondElementType)) {
                return false;
            }
        }
        return true;
    }

    public boolean isEqualToTupleType(DomainTupleType firstTupleType, DomainTupleType secondTupleType) {
        List<? extends DomainTypedElement> firstParts = firstTupleType.getOwnedAttribute();
        List<? extends DomainTypedElement> secondParts = secondTupleType.getOwnedAttribute();
        int iMax = firstParts.size();
        if (iMax != secondParts.size()) {
            return false;
        }
        int i = 0;
        while (i < iMax) {
            DomainType secondType;
            DomainType firstType;
            String secondName;
            DomainTypedElement firstPart = firstParts.get(i);
            DomainTypedElement secondPart = secondParts.get(i);
            String firstName = firstPart.getName();
            if (firstName != (secondName = secondPart.getName())) {
                if (firstName == null) {
                    return false;
                }
                if (!firstName.equals(secondName)) {
                    return false;
                }
            }
            if ((firstType = firstPart.getType()) != (secondType = secondPart.getType())) {
                if (firstType == null) {
                    return false;
                }
                if (!firstType.isEqualTo(this, secondType)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

