/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainTupleType;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.library.LibraryBinaryOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.BagValue;
import org.eclipse.ocl.examples.domain.values.BooleanValue;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.SetValue;
import org.eclipse.ocl.examples.domain.values.TupleValue;
import org.eclipse.ocl.examples.domain.values.UniqueCollectionValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.domain.values.impl.AbstractedCollectionValue;
import org.eclipse.ocl.examples.domain.values.impl.BagValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.OrderedSetValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.SequenceValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.SetValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.TupleValueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollectionValue<C extends Collection<Value>>
extends AbstractedCollectionValue {
    protected final C elements;

    protected AbstractCollectionValue(ValueFactory valueFactory, DomainCollectionType type, C elements) {
        super(valueFactory, type);
        this.elements = elements;
        assert (elements != null);
    }

    @Override
    public BagValue asBagValue() {
        return this.valueFactory.createBagValue(this.getBagType(), this.getElements());
    }

    @Override
    public Object asEcoreObject() {
        BasicEList ecoreResult = new BasicEList(this.intSize());
        for (Value elementValue : this) {
            ecoreResult.add(elementValue.asEcoreObject());
        }
        return ecoreResult;
    }

    @Override
    public OrderedSetValue asOrderedSetValue() {
        return this.valueFactory.createOrderedSetValue(this.getOrderedSetType(), this.getElements());
    }

    @Override
    public SequenceValue asSequenceValue() {
        return this.valueFactory.createSequenceValue(this.getSequenceType(), this.getElements());
    }

    @Override
    public SetValue asSetValue() {
        return this.valueFactory.createSetValue(this.getSetType(), this.getElements());
    }

    @Override
    public IntegerValue count(Value value) throws InvalidValueException {
        long count = 0L;
        for (Value next : this.elements) {
            if (!next.equals(value)) continue;
            ++count;
        }
        return this.valueFactory.integerValueOf(count);
    }

    @Override
    public BooleanValue excludes(Value value) {
        return this.valueFactory.booleanValueOf(!this.elements.contains(value));
    }

    @Override
    public BooleanValue excludesAll(CollectionValue c) {
        for (Value next : c) {
            if (!this.elements.contains(next)) continue;
            return this.valueFactory.getFalse();
        }
        return this.valueFactory.getTrue();
    }

    @Override
    public boolean flatten(Collection<Value> flattenedElements) throws InvalidValueException {
        boolean flattened = false;
        for (Value element : this.elements) {
            CollectionValue collectionElement = element.isCollectionValue();
            if (collectionElement != null) {
                flattened = true;
                collectionElement.flatten(flattenedElements);
                continue;
            }
            flattenedElements.add(element);
        }
        return flattened;
    }

    public DomainCollectionType getBagType() {
        return this.valueFactory.getStandardLibrary().getBagType(this.getElementType());
    }

    @Override
    public DomainCollectionType getCollectionType() {
        return this.getType();
    }

    protected DomainType getElementType() {
        return this.getCollectionType().getElementType();
    }

    @Override
    protected Collection<Value> getElements() {
        return this.elements;
    }

    public DomainCollectionType getOrderedSetType() {
        return this.valueFactory.getStandardLibrary().getOrderedSetType(this.getElementType());
    }

    public DomainCollectionType getSequenceType() {
        return this.valueFactory.getStandardLibrary().getSequenceType(this.getElementType());
    }

    public DomainCollectionType getSetType() {
        return this.valueFactory.getStandardLibrary().getSetType(this.getElementType());
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public BooleanValue includes(Value value) {
        return this.valueFactory.booleanValueOf(this.elements.contains(value));
    }

    @Override
    public BooleanValue includesAll(CollectionValue c) {
        for (Value next : c) {
            if (this.elements.contains(next)) continue;
            return this.valueFactory.getFalse();
        }
        return this.valueFactory.getTrue();
    }

    @Override
    public int intSize() {
        return this.elements.size();
    }

    @Override
    public CollectionValue intersection(CollectionValue c) throws InvalidValueException {
        DomainStandardLibrary standardLibrary = this.valueFactory.getStandardLibrary();
        if (this instanceof OrderedSetValue) {
            return OrderedSetValueImpl.intersection(this.valueFactory, standardLibrary.getOrderedSetType(this.getElementType()), this, c);
        }
        if (this instanceof SequenceValue && c instanceof UniqueCollectionValue) {
            return OrderedSetValueImpl.intersection(this.valueFactory, standardLibrary.getOrderedSetType(this.getElementType()), this, c);
        }
        if (this instanceof UniqueCollectionValue || c instanceof UniqueCollectionValue) {
            return SetValueImpl.intersection(this.valueFactory, standardLibrary.getSetType(this.getElementType()), this, c);
        }
        return BagValueImpl.intersection(this.valueFactory, standardLibrary.getBagType(this.getElementType()), this, c);
    }

    @Override
    public Iterator<Value> iterator() {
        return this.elements != null ? this.elements.iterator() : Collections.emptyList().iterator();
    }

    @Override
    public Value maxMin(DomainEvaluator evaluator, DomainType returnType, LibraryBinaryOperation binaryOperation) throws InvalidValueException {
        Value result = null;
        for (Value element : this.elements) {
            if (result == null) {
                result = element;
                continue;
            }
            if ((result = binaryOperation.evaluate(evaluator, returnType, result, element)) == null) {
                this.valueFactory.throwInvalidValueException(EvaluatorMessages.MissingResult, "max/min");
                continue;
            }
            if (!result.isUndefined()) continue;
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.UndefinedResult, "max/min");
        }
        if (result == null) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.EmptyCollection, this.getKind(), "max/min");
        }
        return result;
    }

    @Override
    public Set<TupleValue> product(CollectionValue c, DomainTupleType tupleType) {
        HashSet<TupleValue> result = new HashSet<TupleValue>();
        for (Value next1 : this) {
            for (Value next2 : c) {
                result.add(new TupleValueImpl(this.valueFactory, tupleType, next1, next2));
            }
        }
        return result;
    }

    @Override
    public CollectionValue selectByKind(DomainType requiredElementType) throws InvalidValueException {
        DomainStandardLibrary standardLibrary = this.valueFactory.getStandardLibrary();
        boolean changedContents = false;
        ArrayList<Value> newElements = new ArrayList<Value>();
        for (Value element : this.elements) {
            if (element.isNull()) {
                changedContents = true;
                continue;
            }
            DomainType elementType = element.getType();
            if (elementType.conformsTo(standardLibrary, requiredElementType)) {
                newElements.add(element);
                continue;
            }
            changedContents = true;
        }
        if (changedContents) {
            DomainCollectionType collectionType = this.getType();
            return this.valueFactory.createCollectionValue(collectionType.isOrdered(), collectionType.isUnique(), newElements);
        }
        return this;
    }

    @Override
    public CollectionValue selectByType(DomainType requiredElementType) throws InvalidValueException {
        DomainStandardLibrary standardLibrary = this.valueFactory.getStandardLibrary();
        boolean changedContents = false;
        ArrayList<Value> newElements = new ArrayList<Value>();
        for (Value element : this.elements) {
            DomainType elementType = element.getType();
            if (elementType.isEqualTo(standardLibrary, requiredElementType)) {
                newElements.add(element);
                continue;
            }
            changedContents = true;
        }
        if (changedContents) {
            DomainCollectionType collectionType = this.getType();
            return this.valueFactory.createCollectionValue(collectionType.isOrdered(), collectionType.isUnique(), newElements);
        }
        return this;
    }

    @Override
    public Value sum(DomainEvaluator evaluator, DomainType returnType, LibraryBinaryOperation binaryOperation, Value zero) throws InvalidValueException {
        Value result = zero;
        for (Value element : this.elements) {
            result = binaryOperation.evaluate(evaluator, returnType, result, element);
        }
        return result;
    }

    @Override
    public CollectionValue union(CollectionValue c) throws InvalidValueException {
        if (this instanceof SetValue && c instanceof SetValue) {
            return SetValueImpl.union(this.valueFactory, this.getSetType(), this, c);
        }
        if (this instanceof BagValue || c instanceof BagValue) {
            return BagValueImpl.union(this.valueFactory, this.getBagType(), this, c);
        }
        if (this instanceof OrderedSetValue && c instanceof OrderedSetValue) {
            return OrderedSetValueImpl.union(this.valueFactory, this.getOrderedSetType(), this, c);
        }
        if (this instanceof SequenceValue || c instanceof SequenceValue) {
            return SequenceValueImpl.union(this.valueFactory, this.getSequenceType(), this, c);
        }
        return SetValueImpl.union(this.valueFactory, this.getSetType(), this, c);
    }
}

