/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.BooleanValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.domain.values.impl.AbstractValue;

public class BooleanValueImpl
extends AbstractValue
implements BooleanValue {
    protected boolean value;

    public BooleanValueImpl(ValueFactory valueFactory, boolean value) {
        super(valueFactory);
        this.value = value;
    }

    public boolean asBoolean() {
        return this.value;
    }

    public BooleanValue asBooleanValue() {
        return this;
    }

    public Object asObject() {
        return this.value;
    }

    public Value asValidValue() {
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BooleanValue) {
            try {
                return this.value == ((BooleanValue)obj).asBoolean();
            }
            catch (InvalidValueException invalidValueException) {
                // empty catch block
            }
        }
        return false;
    }

    public DomainType getType() {
        return this.valueFactory.getStandardLibrary().getBooleanType();
    }

    public int hashCode() {
        return this.value ? 0x72277227 : 0x27722772;
    }

    public boolean isFalse() {
        return !this.value;
    }

    public boolean isTrue() {
        return this.value;
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    public static class Accumulator
    extends BooleanValueImpl
    implements BooleanValue.Accumulator {
        public Accumulator(ValueFactory valueFactory, boolean value) {
            super(valueFactory, value);
        }

        public BooleanValue asBooleanValue() {
            return this.valueFactory.booleanValueOf(this.value);
        }

        public Value asObject() {
            return this.valueFactory.booleanValueOf(this.value);
        }

        public Value asValidValue() {
            return this.valueFactory.booleanValueOf(this.value);
        }

        public void setValue(boolean value) {
            this.value = value;
        }
    }
}

