/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.NumericValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.domain.values.impl.AbstractIntegerValue;
import org.eclipse.ocl.examples.domain.values.impl.IntegerIntValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.RealValueImpl;

public class IntegerLongValueImpl
extends AbstractIntegerValue {
    private final long value;
    private BigInteger bigValue = null;

    public IntegerLongValueImpl(ValueFactory valueFactory, long value) {
        super(valueFactory);
        this.value = value;
    }

    public IntegerValue abs() {
        if (this.value >= 0L) {
            return this;
        }
        if (this.value > Long.MIN_VALUE) {
            return this.valueFactory.integerValueOf(-this.value);
        }
        return this.valueFactory.integerValueOf(BigInteger.ONE.shiftLeft(63));
    }

    public IntegerValue add(IntegerValue right) {
        if (right instanceof IntegerLongValueImpl) {
            long thatValue = ((IntegerLongValueImpl)right).longValue();
            long sum = this.value + thatValue;
            if (this.value >= 0L ? thatValue >= 0L && sum >= 0L : thatValue <= 0L && sum <= 0L) {
                return this.valueFactory.integerValueOf(sum);
            }
        }
        return this.valueFactory.integerValueOf(this.bigIntegerValue().add(right.bigIntegerValue()));
    }

    public Double asDouble() {
        return this.value;
    }

    public Integer asInteger() throws InvalidValueException {
        return this.intValue();
    }

    public Object asObject() {
        return this.value;
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.value);
    }

    public BigInteger bigIntegerValue() {
        if (this.bigValue == null) {
            this.bigValue = BigInteger.valueOf(this.value);
        }
        return this.bigValue;
    }

    public int compareTo(NumericValue o) {
        if (o instanceof IntegerIntValueImpl) {
            int thatValue = ((IntegerIntValueImpl)o).intValue();
            return this.value < (long)thatValue ? -1 : (this.value == (long)thatValue ? 0 : 1);
        }
        if (o instanceof IntegerLongValueImpl) {
            long thatValue = ((IntegerLongValueImpl)o).longValue();
            return this.value < thatValue ? -1 : (this.value == thatValue ? 0 : 1);
        }
        if (o instanceof IntegerValue) {
            return this.bigIntegerValue().compareTo(((IntegerValue)o).bigIntegerValue());
        }
        return Double.compare(this.doubleValue(), o.doubleValue());
    }

    public IntegerValue div(IntegerValue right) throws InvalidValueException {
        if (right.bigIntegerValue().signum() == 0) {
            return null;
        }
        return this.valueFactory.integerValueOf(this.bigIntegerValue().divide(right.bigIntegerValue()));
    }

    public RealValue divide(IntegerValue right) throws InvalidValueException {
        BigDecimal bigLeft = this.bigDecimalValue();
        BigDecimal bigRight = right.bigDecimalValue();
        return RealValueImpl.divideBigDecimal(this.valueFactory, bigLeft, bigRight);
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntegerIntValueImpl) {
            int thatValue = ((IntegerIntValueImpl)obj).intValue();
            return this.value == (long)thatValue;
        }
        if (obj instanceof IntegerLongValueImpl) {
            long thatValue = ((IntegerLongValueImpl)obj).longValue();
            return this.value == thatValue;
        }
        if (obj instanceof IntegerValue) {
            BigInteger bigIntegerValue = ((IntegerValue)obj).bigIntegerValue();
            return bigIntegerValue != null && this.bigIntegerValue().compareTo(bigIntegerValue) == 0;
        }
        if (obj instanceof RealValue) {
            BigDecimal bigDecimalValue = ((RealValue)obj).bigDecimalValue();
            return bigDecimalValue != null && this.bigDecimalValue().compareTo(bigDecimalValue) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public int intValue() throws InvalidValueException {
        int intValue = (int)this.value;
        if ((long)intValue != this.value) {
            throw new InvalidValueException("intValue() overflow");
        }
        return intValue;
    }

    public boolean isUnlimitedNatural() {
        return this.value >= 0L;
    }

    public long longValue() {
        return this.value;
    }

    public IntegerValue max(IntegerValue right) throws InvalidValueException {
        if (right instanceof IntegerIntValueImpl) {
            int thatValue = ((IntegerIntValueImpl)right).intValue();
            return this.value >= (long)thatValue ? this : right;
        }
        if (right instanceof IntegerLongValueImpl) {
            long thatValue = ((IntegerLongValueImpl)right).longValue();
            return this.value >= thatValue ? this : right;
        }
        return this.bigIntegerValue().compareTo(right.bigIntegerValue()) >= 0 ? this : right;
    }

    public IntegerValue min(IntegerValue right) throws InvalidValueException {
        if (right instanceof IntegerIntValueImpl) {
            int thatValue = ((IntegerIntValueImpl)right).intValue();
            return this.value <= (long)thatValue ? this : right;
        }
        if (right instanceof IntegerLongValueImpl) {
            long thatValue = ((IntegerLongValueImpl)right).longValue();
            return this.value <= thatValue ? this : right;
        }
        return this.bigIntegerValue().compareTo(right.bigIntegerValue()) <= 0 ? this : right;
    }

    public IntegerValue mod(IntegerValue right) throws InvalidValueException {
        if (right.bigIntegerValue().signum() == 0) {
            return null;
        }
        return this.valueFactory.integerValueOf(this.bigIntegerValue().remainder(right.bigIntegerValue()));
    }

    public IntegerValue multiply(IntegerValue right) throws InvalidValueException {
        return this.valueFactory.integerValueOf(this.bigIntegerValue().multiply(right.bigIntegerValue()));
    }

    public IntegerValue negate() {
        if (this.value > Long.MIN_VALUE) {
            return this.valueFactory.integerValueOf(-this.value);
        }
        return this.valueFactory.integerValueOf(BigInteger.ONE.shiftLeft(63));
    }

    public int signum() {
        return Long.signum(this.value);
    }

    public IntegerValue subtract(IntegerValue right) throws InvalidValueException {
        if (right instanceof IntegerLongValueImpl) {
            long thatValue = ((IntegerLongValueImpl)right).longValue();
            long diff = this.value - thatValue;
            if (this.value >= 0L ? thatValue <= 0L && diff >= 0L : thatValue >= 0L && diff <= 0L) {
                return this.valueFactory.integerValueOf(diff);
            }
        }
        return this.valueFactory.integerValueOf(this.bigIntegerValue().subtract(right.bigIntegerValue()));
    }

    public String toString() {
        return Long.toString(this.value);
    }
}

