/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.IntegerRange;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntegerRangeImpl
extends AbstractList<Value>
implements IntegerRange {
    protected final IntegerValue first;
    protected final IntegerValue last;
    protected final IntegerValue fullSize;
    protected final Integer size;

    public IntegerRangeImpl(IntegerValue first, IntegerValue last) throws InvalidValueException {
        IntegerValue sizeMinusOne = last.subtract(first);
        this.first = first;
        this.last = last;
        if (sizeMinusOne.signum() < 0) {
            this.fullSize = this.getValueFactory().getZero();
            this.size = 0;
        } else {
            this.fullSize = sizeMinusOne.add(this.getValueFactory().getOne());
            this.size = this.fullSize.asInteger();
        }
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof IntegerValue)) {
            return false;
        }
        IntegerValue value = (IntegerValue)o;
        return this.first.compareTo(value) <= 0 && value.compareTo(this.last) <= 0;
    }

    @Override
    public IntegerValue get(int index) {
        if (index < 0 || this.size == null || index >= this.size) {
            throw new NoSuchElementException();
        }
        try {
            return this.first.add(this.getValueFactory().integerValueOf(index));
        }
        catch (InvalidValueException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public IntegerValue getFirst() {
        return this.first;
    }

    @Override
    public IntegerValue getLast() {
        return this.last;
    }

    @Override
    public IntegerValue getSize() {
        return this.fullSize;
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.first.getValueFactory();
    }

    @Override
    public Iterator<Value> iterator() {
        return new IntegerRangeIterator();
    }

    @Override
    public int size() {
        if (this.size != null) {
            return this.size;
        }
        throw new NoSuchElementException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IntegerRangeIterator
    implements Iterator<Value> {
        private IntegerValue curr = null;

        IntegerRangeIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.curr == null) {
                return IntegerRangeImpl.this.first.compareTo(IntegerRangeImpl.this.last) <= 0;
            }
            return !IntegerRangeImpl.this.last.equals(this.curr);
        }

        @Override
        public IntegerValue next() {
            if (this.curr == null) {
                this.curr = IntegerRangeImpl.this.first;
            } else if (this.curr.compareTo(IntegerRangeImpl.this.last) < 0) {
                try {
                    this.curr = this.curr.add(IntegerRangeImpl.this.getValueFactory().getOne());
                }
                catch (InvalidValueException e) {
                    throw new NoSuchElementException();
                }
            } else {
                throw new NoSuchElementException();
            }
            return this.curr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.valueOf(this.curr);
        }
    }
}

