/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.IntegerRange;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.domain.values.impl.AbstractSequenceValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceRangeImpl
extends AbstractSequenceValue<IntegerRange> {
    public SequenceRangeImpl(ValueFactory valueFactory, DomainCollectionType type, IntegerRange range) {
        super(valueFactory, type, range);
    }

    @Override
    public SequenceValue append(Value value) throws InvalidValueException {
        IntegerValue nextValue = ((IntegerRange)this.elements).getLast().add(this.valueFactory.getOne());
        if (value.equals(nextValue)) {
            IntegerRange range = this.valueFactory.createRange(((IntegerRange)this.elements).getFirst(), nextValue);
            return new SequenceRangeImpl(this.valueFactory, this.getCollectionType(), range);
        }
        List<Value> elements = this.createElements();
        elements.add(value);
        return this.valueFactory.createSequenceValue(this.getCollectionType(), elements);
    }

    @Override
    public IntegerValue count(Value value) throws InvalidValueException {
        IntegerValue integerValue = value.isIntegerValue();
        if (integerValue != null && !integerValue.isUndefined() && ((IntegerRange)this.elements).contains(integerValue)) {
            return this.valueFactory.getOne();
        }
        return this.valueFactory.getZero();
    }

    protected List<Value> createElements() {
        ArrayList<Value> elements = new ArrayList<Value>(this.intSize());
        for (Value value : this) {
            elements.add(value);
        }
        return elements;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SequenceRangeImpl) {
            SequenceRangeImpl that = (SequenceRangeImpl)obj;
            return ((IntegerRange)this.elements).equals(that.elements);
        }
        return super.equals(obj);
    }

    @Override
    public Value first() {
        return ((IntegerRange)this.elements).getFirst();
    }

    @Override
    public SequenceValue flatten() {
        return this;
    }

    public List<Value> getElements() {
        if (this.elements == null) {
            this.createElements();
        }
        return (List)this.elements;
    }

    @Override
    public SequenceValue including(Value value) throws InvalidValueException {
        return this.append(value);
    }

    @Override
    public Value last() {
        return ((IntegerRange)this.elements).getLast();
    }

    @Override
    public SequenceValue prepend(Value value) throws InvalidValueException {
        IntegerValue previousValue = ((IntegerRange)this.elements).getFirst().subtract(this.valueFactory.getOne());
        if (value.equals(previousValue)) {
            IntegerRange range = this.valueFactory.createRange(previousValue, ((IntegerRange)this.elements).getLast());
            return new SequenceRangeImpl(this.valueFactory, this.getCollectionType(), range);
        }
        List<Value> elements = this.createElements();
        elements.add(0, value);
        return this.valueFactory.createSequenceValue(this.getCollectionType(), elements);
    }

    @Override
    public Iterator<Value> toIteratorValue() throws InvalidValueException {
        return this.getElements().iterator();
    }

    @Override
    public void toString(StringBuilder s, int lengthLimit) {
        s.append("Sequence{");
        s.append(((IntegerRange)this.elements).getFirst());
        s.append("..");
        s.append(((IntegerRange)this.elements).getLast());
        s.append("}");
        s.toString();
    }
}

