/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.evaluation.InvalidValueException;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.domain.values.impl.AbstractSequenceValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceValueImpl
extends AbstractSequenceValue<List<Value>> {
    public static SequenceValue union(ValueFactory valueFactory, DomainCollectionType type, CollectionValue left, CollectionValue right) throws InvalidValueException {
        assert (!left.isUndefined() && !right.isUndefined());
        Collection<Value> leftElements = left.asCollection();
        Collection<Value> rightElements = right.asCollection();
        if (leftElements.isEmpty()) {
            return right.asSequenceValue();
        }
        if (rightElements.isEmpty()) {
            return left.asSequenceValue();
        }
        ArrayList<Value> result = new ArrayList<Value>(leftElements);
        result.addAll(rightElements);
        return new SequenceValueImpl(valueFactory, type, (List<Value>)result);
    }

    public SequenceValueImpl(ValueFactory valueFactory, DomainCollectionType type, Value ... elements) {
        super(valueFactory, type, new ArrayList());
        if (elements != null) {
            Value[] valueArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Value element = valueArray[n2];
                ((List)this.elements).add(element);
                ++n2;
            }
        }
    }

    public SequenceValueImpl(ValueFactory valueFactory, DomainCollectionType type, Collection<? extends Value> elements) {
        super(valueFactory, type, new ArrayList<Value>(elements));
    }

    public SequenceValueImpl(ValueFactory valueFactory, DomainCollectionType type, List<Value> elements) {
        super(valueFactory, type, elements);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SequenceValueImpl) {
            return ((List)this.elements).equals(((SequenceValueImpl)obj).elements);
        }
        return super.equals(obj);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Accumulator
    extends SequenceValueImpl
    implements CollectionValue.Accumulator {
        public Accumulator(ValueFactory valueFactory, DomainCollectionType type) {
            super(valueFactory, type, new Value[0]);
        }

        public Accumulator(ValueFactory valueFactory, DomainCollectionType type, List<Value> elements) {
            super(valueFactory, type, elements);
        }

        @Override
        public boolean add(Value value) {
            return ((List)this.elements).add(value);
        }

        @Override
        public SequenceValue append(Value object) throws InvalidValueException {
            if (object.isInvalid()) {
                this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "append");
            }
            ((List)this.elements).add(object);
            return this;
        }
    }
}

