/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ocl.examples.domain.elements.DomainTupleType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.values.TupleValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValueFactory;
import org.eclipse.ocl.examples.domain.values.impl.AbstractValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleValueImpl
extends AbstractValue
implements TupleValue {
    protected final DomainTupleType type;
    private final Map<String, Value> parts = new HashMap<String, Value>();
    private Integer hashCode = null;

    public TupleValueImpl(ValueFactory valueFactory, DomainTupleType type, Map<? extends DomainTypedElement, Value> values) {
        super(valueFactory);
        this.type = type;
        for (Map.Entry<? extends DomainTypedElement, Value> entry : values.entrySet()) {
            this.parts.put(entry.getKey().getName(), entry.getValue());
        }
    }

    public TupleValueImpl(ValueFactory valueFactory, DomainTupleType type, Value firstValue, Value secondValue) {
        super(valueFactory);
        this.type = type;
        this.parts.put("first", firstValue);
        this.parts.put("second", secondValue);
    }

    @Override
    public Object asObject() {
        return this.parts;
    }

    @Override
    public Value asValidValue() {
        return this;
    }

    public boolean equals(Object o) {
        boolean result = o instanceof TupleValueImpl;
        if (result) {
            TupleValueImpl other = (TupleValueImpl)o;
            result &= other.type.equals(this.type);
            result &= other.parts.equals(this.parts);
        }
        return result;
    }

    @Override
    public DomainTupleType getType() {
        return this.type;
    }

    @Override
    public Value getValue(String partName) {
        return this.parts.get(partName);
    }

    @Override
    public Value getValue(DomainTypedElement part) {
        return this.getValue(part.getName());
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int typeHashCode = this.type.hashCode();
            int partsHashCode = this.parts.hashCode();
            this.hashCode = 37 * typeHashCode + 17 * partsHashCode;
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Tuple{");
        Iterator<? extends DomainTypedElement> iter = this.getType().getOwnedAttribute().iterator();
        while (iter.hasNext()) {
            DomainTypedElement p = iter.next();
            result.append(p.getName());
            result.append(" = ");
            result.append(this.toString(this.getValue(p)));
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append("}");
        return result.toString();
    }

    private String toString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString();
    }
}

