/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclstdlib.cs2pivot;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.Library;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.BasicContinuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuations;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Dependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.SingleContinuation;
import org.eclipse.ocl.examples.xtext.oclstdlib.cs2pivot.AbstractOCLstdlibPreOrderVisitor;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibClassCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibIterationCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibOperationCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibPropertyCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.LibRootPackageCS;
import org.eclipse.ocl.examples.xtext.oclstdlib.oclstdlibCST.PrecedenceCS;
import org.eclipse.xtext.common.types.JvmType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLstdlibPreOrderVisitor
extends AbstractOCLstdlibPreOrderVisitor {
    public OCLstdlibPreOrderVisitor(CS2PivotConversion context) {
        super(context);
    }

    @Override
    public Continuation<?> visitLibClassCS(LibClassCS csLibClass) {
        Type type = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csLibClass);
        Continuation continuation = super.visitLibClassCS(csLibClass);
        if (type instanceof CollectionType) {
            continuation = Continuations.combine((Continuation[])new Continuation[]{continuation, new CollectionElementTypeContinuation((CS2PivotConversion)this.context, csLibClass)});
        } else if (type instanceof ClassifierType) {
            continuation = Continuations.combine((Continuation[])new Continuation[]{continuation, new ClassifierInstanceTypeContinuation((CS2PivotConversion)this.context, csLibClass)});
        }
        return continuation;
    }

    @Override
    public Continuation<?> visitLibIterationCS(LibIterationCS csIteration) {
        return new LibIterationContinuation((CS2PivotConversion)this.context, csIteration);
    }

    @Override
    public Continuation<?> visitLibOperationCS(LibOperationCS csOperation) {
        return new LibOperationContinuation((CS2PivotConversion)this.context, csOperation);
    }

    @Override
    public Continuation<?> visitLibPropertyCS(LibPropertyCS csProperty) {
        return new LibPropertyContinuation((CS2PivotConversion)this.context, csProperty);
    }

    @Override
    public Continuation<?> visitLibRootPackageCS(LibRootPackageCS csLibRootPackage) {
        Continuation<?> superContinuation = super.visitLibRootPackageCS(csLibRootPackage);
        LibraryPrecedenceContinuation localContinuation = new LibraryPrecedenceContinuation((CS2PivotConversion)this.context, csLibRootPackage);
        return Continuations.combine((Continuation[])new Continuation[]{superContinuation, localContinuation});
    }

    @Override
    public Continuation<?> visitPrecedenceCS(PrecedenceCS csPrecedence) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ClassifierInstanceTypeContinuation
    extends SingleContinuation<LibClassCS> {
        public ClassifierInstanceTypeContinuation(CS2PivotConversion context, LibClassCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[0]);
        }

        public BasicContinuation<?> execute() {
            TemplateParameter templateParameter;
            EList parameters;
            ClassifierType type = (ClassifierType)PivotUtil.getPivot(ClassifierType.class, (Pivotable)((Pivotable)this.csElement));
            TemplateSignature ownedTemplateSignature = type.getOwnedTemplateSignature();
            if (ownedTemplateSignature != null && (parameters = ownedTemplateSignature.getParameter()).size() > 0 && (templateParameter = (TemplateParameter)parameters.get(0)) != null) {
                type.setInstanceType((Type)templateParameter.getParameteredElement());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CollectionElementTypeContinuation
    extends SingleContinuation<LibClassCS> {
        public CollectionElementTypeContinuation(CS2PivotConversion context, LibClassCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[0]);
        }

        public BasicContinuation<?> execute() {
            EList parameters;
            CollectionType type = (CollectionType)PivotUtil.getPivot(CollectionType.class, (Pivotable)((Pivotable)this.csElement));
            TemplateSignature ownedTemplateSignature = type.getOwnedTemplateSignature();
            if (ownedTemplateSignature != null && (parameters = ownedTemplateSignature.getParameter()).size() > 0) {
                type.setElementType((Type)((TemplateParameter)parameters.get(0)).getParameteredElement());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LibIterationContinuation
    extends SingleContinuation<LibIterationCS> {
        public LibIterationContinuation(CS2PivotConversion context, LibIterationCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[0]);
        }

        public BasicContinuation<?> execute() {
            Iteration pivotIteration = (Iteration)PivotUtil.getPivot(Iteration.class, (Pivotable)((Pivotable)this.csElement));
            JvmType implementation = ((LibIterationCS)this.csElement).getImplementation();
            if (implementation != null && !implementation.eIsProxy()) {
                pivotIteration.setImplementationClass(implementation.getIdentifier());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LibOperationContinuation
    extends SingleContinuation<LibOperationCS> {
        public LibOperationContinuation(CS2PivotConversion context, LibOperationCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[0]);
        }

        public BasicContinuation<?> execute() {
            Operation pivotElement = (Operation)PivotUtil.getPivot(Operation.class, (Pivotable)((Pivotable)this.csElement));
            Precedence precedence = ((LibOperationCS)this.csElement).getPrecedence();
            if (precedence != null && precedence.eIsProxy()) {
                precedence = null;
            }
            pivotElement.setPrecedence(precedence);
            pivotElement.setIsStatic(((LibOperationCS)this.csElement).isStatic());
            JvmType implementation = ((LibOperationCS)this.csElement).getImplementation();
            if (implementation != null && !implementation.eIsProxy()) {
                pivotElement.setImplementationClass(implementation.getIdentifier());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LibPropertyContinuation
    extends SingleContinuation<LibPropertyCS> {
        public LibPropertyContinuation(CS2PivotConversion context, LibPropertyCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[0]);
        }

        public BasicContinuation<?> execute() {
            Property pivotElement = (Property)PivotUtil.getPivot(Property.class, (Pivotable)((Pivotable)this.csElement));
            pivotElement.setIsStatic(((LibPropertyCS)this.csElement).isStatic());
            JvmType implementation = ((LibPropertyCS)this.csElement).getImplementation();
            if (implementation != null && !implementation.eIsProxy()) {
                pivotElement.setImplementationClass(implementation.getIdentifier());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LibraryPrecedenceContinuation
    extends SingleContinuation<LibRootPackageCS> {
        private LibraryPrecedenceContinuation(CS2PivotConversion context, LibRootPackageCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[0]);
        }

        public BasicContinuation<?> execute() {
            Library pivotElement = (Library)PivotUtil.getPivot(Library.class, (Pivotable)((Pivotable)this.csElement));
            this.context.refreshPivotList(Precedence.class, (List)pivotElement.getOwnedPrecedence(), ((LibRootPackageCS)this.csElement).getOwnedPrecedence());
            return null;
        }
    }
}

