/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenOperation;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.library.LibraryConstants;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.Library;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PivotConstants;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.uml2.codegen.ecore.genmodel.util.UML2GenModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenPackageQueries {
    public Type getAnotherType(GenPackage genPackage, Type type) {
        MetaModelManager metaModelManager = this.getMetaModelManager(genPackage);
        Type primaryType = metaModelManager.getPrimaryType(type);
        return primaryType;
    }

    public String getCopyright(GenPackage genPackage, String indentation) {
        return genPackage.getCopyright(indentation);
    }

    public String getEcorePackageName(GenPackage genPackage) {
        return genPackage.getEcorePackage().getName();
    }

    public String getFeatureTypeCast(GenPackage genPackage, Feature typedElement) {
        return "(" + typedElement.getClass().getSimpleName() + ")";
    }

    public GenClass getGenClass(GenPackage genPackage, Type type) {
        String name = type.getName();
        for (GenClass genClass : genPackage.getGenClasses()) {
            String clsName = genClass.getEcoreClass().getName();
            if (!name.equals(clsName)) continue;
            return genClass;
        }
        return null;
    }

    public GenFeature getGenFeature(GenPackage genPackage, GenClass genClass, Property property) {
        String name = property.getName();
        for (GenFeature genFeature : genClass.getGenFeatures()) {
            String featureName = genFeature.getEcoreFeature().getName();
            if (!name.equals(featureName)) continue;
            return genFeature;
        }
        return null;
    }

    public GenOperation getGenOperation(GenPackage genPackage, GenClass genClass, Operation operation) {
        String name = operation.getName();
        for (GenOperation genOperation : genClass.getGenOperations()) {
            if (!name.equals(genOperation.getName())) continue;
            return genOperation;
        }
        return null;
    }

    public GenPackage getGenPackage(GenPackage genPackage, Package pivotPackage) {
        if (pivotPackage == null) {
            return genPackage;
        }
        EPackage firstEPackage = genPackage.getEcorePackage();
        if (firstEPackage.getName().equals(pivotPackage.getName())) {
            return genPackage;
        }
        GenModel genModel = genPackage.getGenModel();
        EList usedGenPackages = genModel.getUsedGenPackages();
        Resource genModelResource = genPackage.eResource();
        ResourceSet genModelResourceSet = genModelResource.getResourceSet();
        MetaModelManager metaModelManager = this.getMetaModelManager(genPackage);
        Package metaModelPackage = metaModelManager.getPivotMetaModel();
        Package libraryPackage = (Package)metaModelManager.getLibraries().get(0);
        if (pivotPackage == libraryPackage) {
            Object libraryGenPackage = this.getLibraryGenPackage((List)usedGenPackages);
            if (libraryGenPackage == null) {
                libraryGenPackage = this.loadGenPackage(genModelResourceSet, LibraryConstants.GEN_MODEL_URI);
            }
            return libraryGenPackage;
        }
        if (pivotPackage == metaModelPackage) {
            Object metaModelGenPackage = this.getMetaModelGenPackage((List)usedGenPackages);
            if (metaModelGenPackage == null) {
                metaModelGenPackage = this.loadGenPackage(genModelResourceSet, PivotConstants.GEN_MODEL_URI);
            }
            return metaModelGenPackage;
        }
        return genPackage;
    }

    protected MetaModelManager getMetaModelManager(GenPackage genPackage) {
        Resource genModelResource = genPackage.eResource();
        ResourceSet genModelResourceSet = genModelResource.getResourceSet();
        MetaModelManagerResourceSetAdapter resourceSetAdapter = MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)genModelResourceSet, null);
        MetaModelManager metaModelManager = resourceSetAdapter.getMetaModelManager();
        return metaModelManager;
    }

    public String getInterfacePackageName(GenPackage genPackage) {
        return genPackage.getInterfacePackageName();
    }

    private <T extends GenPackage> T getLibraryGenPackage(List<T> genPackages) {
        for (GenPackage genPackage : genPackages) {
            EPackage ecorePackage = genPackage.getEcorePackage();
            EClassifier eClassifier = ecorePackage.getEClassifier("_Dummy");
            if (eClassifier == null) continue;
            return (T)genPackage;
        }
        return null;
    }

    private <T extends GenPackage> T getMetaModelGenPackage(List<T> genPackages) {
        for (GenPackage genPackage : genPackages) {
            EPackage ecorePackage = genPackage.getEcorePackage();
            EClassifier eClassifier = ecorePackage.getEClassifier("Element");
            if (eClassifier == null) continue;
            return (T)genPackage;
        }
        return null;
    }

    private <T extends GenClassifier> T getNamedElement1(List<T> genClasses, String name) {
        for (GenClassifier genClass : genClasses) {
            if (!genClass.getName().equals(name)) continue;
            return (T)genClass;
        }
        return null;
    }

    private <T extends GenFeature> T getNamedElement2(List<T> genClasses, String name) {
        for (GenFeature genClass : genClasses) {
            if (!genClass.getName().equals(name)) continue;
            return (T)genClass;
        }
        return null;
    }

    protected static boolean isBlank(String string) {
        return string == null || string.length() == 0;
    }

    public String getOperationID(GenPackage genPackage, Type type, Constraint rule, Boolean diagnosticCode) {
        GenClass genClass = this.getGenClass(genPackage, type);
        if (genClass != null) {
            String prefix = null;
            prefix = UML2GenModelUtil.getInvariantPrefix((GenModel)genPackage.getGenModel());
            String name = rule.isCallable() ? rule.getName() : String.valueOf(prefix) + rule.getName();
            for (GenOperation genOperation : genClass.getGenOperations()) {
                String operationID;
                String opName = genOperation.getEcoreOperation().getName();
                if (!name.equals(opName)) continue;
                if (!GenPackageQueries.isBlank(prefix)) {
                    String upperCaseOpName = CodeGenUtil.format((String)genOperation.getName(), (char)'_', (String)prefix, (boolean)false, (boolean)false).toUpperCase();
                    operationID = String.valueOf(genClass.getClassifierID()) + "__" + upperCaseOpName;
                } else {
                    operationID = genClass.getOperationID(genOperation, diagnosticCode.booleanValue());
                }
                return operationID;
            }
        }
        return "<<unknown-OperationId>>";
    }

    public String getOperationReturnType(GenPackage genPackage, Operation operation) {
        GenOperation genOperation;
        GenClass genClass = this.getGenClass(genPackage, operation.getOwningType());
        if (genClass != null && (genOperation = this.getGenOperation(genPackage, genClass, operation)) != null) {
            return genOperation.getObjectType(genClass);
        }
        return "";
    }

    public Package getPivotPackage(GenPackage genPackage) {
        MetaModelManager metaModelManager;
        EPackage ePackage = genPackage.getEcorePackage();
        Resource ecoreResource = ePackage.eResource();
        Ecore2Pivot ecore2Pivot = Ecore2Pivot.getAdapter((Resource)ecoreResource, (MetaModelManager)(metaModelManager = this.getMetaModelManager(genPackage)));
        Package pivotPackage = (Package)ecore2Pivot.getCreated(Package.class, (EObject)ePackage);
        if (pivotPackage.getNsURI().equals("http://www.eclipse.org/ocl/3.1.0/OCL.oclstdlib")) {
            this.mergeLibrary(metaModelManager, pivotPackage);
        }
        return pivotPackage;
    }

    public String getPropertyType(GenPackage genPackage, Property property) {
        GenFeature genFeature;
        GenClass genClass = this.getGenClass(genPackage, property.getOwningType());
        if (genClass != null && (genFeature = this.getGenFeature(genPackage, genClass, property)) != null) {
            return genFeature.getObjectType(genClass);
        }
        return "";
    }

    public String getQualifyingPackage(GenPackage genPackage, Type type) {
        GenPackage genPackage2 = this.getGenPackage(genPackage, type.getPackage());
        return genPackage2 != null ? String.valueOf(genPackage2.getQualifiedPackageName()) + "." + genPackage2.getPrefix() + "Tables" : "";
    }

    public String getQualifiedPackageName(GenPackage genPackage) {
        return genPackage.getQualifiedPackageName();
    }

    public String getQualifiedValidatorClassName(GenPackage genPackage) {
        return genPackage.getQualifiedValidatorClassName();
    }

    public String getSharedLibrary(GenPackage genPackage) {
        Package thisPackage = this.getPivotPackage(genPackage);
        MetaModelManager metaModelManager = this.getMetaModelManager(genPackage);
        PrimitiveType booleanType = metaModelManager.getBooleanType();
        TypeServer typeServer = metaModelManager.getTypeServer((Type)booleanType);
        for (Type type : typeServer.getTypes()) {
            if (type.getPackage() == thisPackage) continue;
            GenPackage gPackage = this.getGenPackage(genPackage, type.getPackage());
            return String.valueOf(this.getInterfacePackageName(gPackage)) + "." + gPackage.getPrefix() + "Tables";
        }
        return "";
    }

    public Boolean hasAnotherType(GenPackage genPackage, Type type) {
        MetaModelManager metaModelManager = this.getMetaModelManager(genPackage);
        Type primaryType = metaModelManager.getPrimaryType(type);
        if (primaryType != type) {
            return true;
        }
        return false;
    }

    public Boolean hasEcore(GenPackage genPackage, Property property) {
        GenClass genClass = (GenClass)this.getNamedElement1((List)genPackage.getGenClasses(), property.getOwningType().getName());
        if (genClass == null) {
            return false;
        }
        Object genFeature = this.getNamedElement2(genClass.getAllGenFeatures(), property.getName());
        if (genFeature == null) {
            return false;
        }
        return true;
    }

    public Boolean hasEcore(GenPackage genPackage, Type type) {
        GenClass genClass = (GenClass)this.getNamedElement1((List)genPackage.getGenClasses(), type.getName());
        if (genClass != null) {
            return true;
        }
        GenEnum genEnum = (GenEnum)this.getNamedElement1((List)genPackage.getGenEnums(), type.getName());
        if (genEnum != null) {
            return true;
        }
        return false;
    }

    public Boolean hasSharedLibrary(GenPackage genPackage) {
        Package thisPackage = this.getPivotPackage(genPackage);
        MetaModelManager metaModelManager = this.getMetaModelManager(genPackage);
        PrimitiveType booleanType = metaModelManager.getBooleanType();
        TypeServer typeServer = metaModelManager.getTypeServer((Type)booleanType);
        boolean gotThatPackage = false;
        boolean gotThisPackage = false;
        for (Type type : typeServer.getTypes()) {
            if (type.getPackage() == thisPackage) {
                gotThisPackage = true;
                continue;
            }
            gotThatPackage = true;
        }
        if (gotThisPackage && gotThatPackage) {
            return true;
        }
        return false;
    }

    private GenPackage loadGenPackage(ResourceSet resourceSet, URI genModelURI) {
        Resource resource = resourceSet.getResource(genModelURI, true);
        GenModel genModel = (GenModel)resource.getContents().get(0);
        return (GenPackage)genModel.getGenPackages().get(0);
    }

    protected void mergeLibrary(MetaModelManager metaModelManager, Package primaryPackage) {
        EList primaryTypes = primaryPackage.getOwnedType();
        for (Library library : metaModelManager.getLibraries()) {
            Type primaryType;
            HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
            ArrayList libraryTypes = new ArrayList(library.getOwnedType());
            for (Type secondaryType : libraryTypes) {
                primaryType = (Type)PivotUtil.getNamedElement((Iterable)primaryTypes, (String)secondaryType.getName());
                if (primaryType != null) {
                    typeMap.put(secondaryType, primaryType);
                    continue;
                }
                primaryTypes.add(secondaryType);
            }
            for (Type secondaryType : libraryTypes) {
                primaryType = (Type)typeMap.get(secondaryType);
                if (primaryType == null) continue;
                EList primarySuperClasses = primaryType.getSuperClass();
                for (Type secondarySuperClass : secondaryType.getSuperClass()) {
                    Type primarySuperClass = (Type)typeMap.get(secondarySuperClass);
                    if (primarySuperClass == null) {
                        primarySuperClasses.add(secondarySuperClass);
                        continue;
                    }
                    if (primarySuperClasses.contains(primarySuperClass)) continue;
                    primarySuperClasses.add(primarySuperClass);
                }
                primaryType.getOwnedOperation().addAll((Collection)secondaryType.getOwnedOperation());
                primaryType.getOwnedAttribute().addAll((Collection)secondaryType.getOwnedAttribute());
            }
        }
        for (Type primaryType : primaryTypes) {
            if (!(primaryType instanceof Type)) continue;
            EList primarySuperClasses = primaryType.getSuperClass();
            Type classType = (Type)PivotUtil.getNamedElement((Iterable)primarySuperClasses, (String)"Class");
            Type classifierType = (Type)PivotUtil.getNamedElement((Iterable)primarySuperClasses, (String)"Classifier");
            if (classType == null || classifierType == null) continue;
            primarySuperClasses.remove(classType);
        }
    }
}

