/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.ecore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.generation.strategy.PreviewStrategy;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenAnnotation;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenBaseGeneratorAdapter;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.common.internal.options.CodeGenerationMode;
import org.eclipse.ocl.common.internal.options.CommonOptions;
import org.eclipse.ocl.common.preferences.PreferenceableOption;
import org.eclipse.ocl.examples.codegen.ecore.OCL2Java4genmodel;
import org.eclipse.ocl.examples.codegen.ecore.OCLGeneratorAdapterFactory;
import org.eclipse.ocl.examples.codegen.tables.Model2bodies;
import org.eclipse.ocl.examples.codegen.tables.Model2tables;
import org.eclipse.ocl.examples.library.LibraryConstants;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.utilities.Pivot2Moniker;
import org.eclipse.uml2.codegen.ecore.genmodel.util.UML2GenModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLGenModelGeneratorAdapter
extends GenBaseGeneratorAdapter {
    public static final String OCL_GENMODEL_URI = "http://www.eclipse.org/OCL/GenModel";
    public static final String USE_DELEGATES_KEY = "Use Delegates";
    private Set<GenModel> hadDelegates = new HashSet<GenModel>();

    public static boolean useDelegates(GenModel genModel) {
        GenAnnotation genAnnotation = genModel.getGenAnnotation(OCL_GENMODEL_URI);
        if (genAnnotation != null) {
            EMap details = genAnnotation.getDetails();
            return Boolean.valueOf((String)details.get((Object)USE_DELEGATES_KEY));
        }
        CodeGenerationMode preference = (CodeGenerationMode)OCLCommon.getPreference((PreferenceableOption)CommonOptions.CODE_GENERATION_MODE, null);
        return preference == CodeGenerationMode.DELEGATED;
    }

    public OCLGenModelGeneratorAdapter(OCLGeneratorAdapterFactory generatorAdapterFactory) {
        super((GeneratorAdapterFactory)generatorAdapterFactory);
    }

    protected void convertConstraintToOperation(Ecore2Pivot ecore2pivot, GenModel genModel, EClassifier eClassifier, String key, String body, String message) {
        Type pType = (Type)ecore2pivot.getCreated(Type.class, (EObject)eClassifier);
        EList ownedRules = pType.getOwnedRule();
        for (Constraint rule : ownedRules) {
            String ruleName = rule.getName();
            if (ruleName == null) {
                ruleName = "";
            }
            if (!rule.getStereotype().equals("invariant") || !ruleName.equals(key)) continue;
            String prefix = UML2GenModelUtil.getInvariantPrefix((GenModel)genModel);
            EOperation eOperation = Pivot2Ecore.createConstraintEOperation((Constraint)rule, (String)(String.valueOf(prefix) + ruleName));
            ((EClass)eClassifier).getEOperations().add((Object)eOperation);
            ecore2pivot.addMapping((EObject)eOperation, (Element)rule);
            EcoreUtil.setAnnotation((EModelElement)eOperation, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", (String)"body", (String)body);
            if (message == null) continue;
            EcoreUtil.setAnnotation((EModelElement)eOperation, (String)"http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", (String)"body$message", (String)message);
        }
    }

    protected void convertConstraintsToOperations(MetaModelManager metaModelManager, GenModel genModel) {
        List genPackages = genModel.getAllGenPackagesWithClassifiers();
        for (GenPackage genPackage : genPackages) {
            EPackage ecorePackage = genPackage.getEcorePackage();
            Ecore2Pivot ecore2pivot = Ecore2Pivot.getAdapter((Resource)ecorePackage.eResource(), (MetaModelManager)metaModelManager);
            for (GenClass genClass : genPackage.getGenClasses()) {
                EClass eClass;
                EClass eClassifier = eClass = genClass.getEcoreClass();
                ArrayList<EAnnotation> obsoleteAnnotations = null;
                for (EAnnotation eAnnotation : eClassifier.getEAnnotations()) {
                    String source = eAnnotation.getSource();
                    if (OCLCommon.isDelegateURI((String)source)) {
                        EMap details = eAnnotation.getDetails();
                        for (String key : details.keySet()) {
                            if (key == null || key.endsWith("$message")) continue;
                            String expression = (String)details.get((Object)key);
                            String messageExpression = (String)details.get((Object)(String.valueOf(key) + "$message"));
                            this.convertConstraintToOperation(ecore2pivot, genModel, (EClassifier)eClassifier, key, expression, messageExpression);
                        }
                        if (obsoleteAnnotations == null) {
                            obsoleteAnnotations = new ArrayList<EAnnotation>();
                        }
                        obsoleteAnnotations.add(eAnnotation);
                    }
                    if (!"http://www.eclipse.org/emf/2002/Ecore".equals(source)) continue;
                    eAnnotation.getDetails().remove((Object)"constraints");
                }
                if (obsoleteAnnotations != null) {
                    eClassifier.getEAnnotations().removeAll(obsoleteAnnotations);
                }
                genClass.initialize(eClass);
            }
        }
    }

    protected void createClassBodies(GenModel genModel, Monitor monitor) throws IOException {
        File projectFolder = this.getProjectFolder(genModel);
        ArrayList arguments = new ArrayList();
        Model2bodies generator = new Model2bodies((EObject)genModel, projectFolder, arguments);
        generator.generate(monitor);
    }

    protected void createDispatchTables(GenModel genModel, Monitor monitor) throws IOException {
        File projectFolder = this.getProjectFolder(genModel);
        ArrayList arguments = new ArrayList();
        Model2tables generator = new Model2tables((EObject)genModel, projectFolder, arguments);
        generator.generate(monitor);
    }

    protected Map<String, String> createFeatureBodies(GenModel genModel) throws IOException {
        HashMap<String, String> results = new HashMap<String, String>();
        File folder = new File("/");
        ArrayList arguments = new ArrayList();
        OCL2Java4genmodel generator = new OCL2Java4genmodel((EObject)genModel, folder, arguments){

            public IAcceleoGenerationStrategy getGenerationStrategy() {
                return new PreviewStrategy();
            }
        };
        Map<String, String> result = generator.generate((Monitor)new BasicMonitor());
        for (String key : result.keySet()) {
            String key2 = "/" + key.replace('\\', '/');
            String value = result.get(key);
            results.put(key2, value);
        }
        return results;
    }

    protected Diagnostic doPreGenerate(Object object, Object projectType) {
        GenModel genModel = (GenModel)object;
        try {
            if (projectType == "org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject" && !OCLGenModelGeneratorAdapter.useDelegates(genModel) && this.hasDelegates(genModel)) {
                EList modelPluginVariables = genModel.getModelPluginVariables();
                if (!modelPluginVariables.contains(LibraryConstants.PLUGIN_ID)) {
                    modelPluginVariables.add(LibraryConstants.PLUGIN_ID);
                }
                GenPackage genPackage = (GenPackage)genModel.getGenPackages().get(0);
                this.createImportManager(genPackage.getReflectionPackageName(), String.valueOf(genPackage.getFactoryInterfaceName()) + "Tables");
                Resource genResource = genModel.eResource();
                ResourceSet resourceSet = genResource.getResourceSet();
                MetaModelManager metaModelManager = MetaModelManager.findAdapter((ResourceSet)resourceSet);
                MetaModelManagerResourceSetAdapter adapter = MetaModelManagerResourceSetAdapter.getAdapter((ResourceSet)resourceSet, (MetaModelManager)metaModelManager);
                metaModelManager = adapter.getMetaModelManager();
                this.convertConstraintsToOperations(metaModelManager, genModel);
                Map<String, String> results = this.createFeatureBodies(genModel);
                this.installJavaBodies(metaModelManager, genModel, results);
                this.pruneDelegates(genModel);
            }
        }
        catch (Exception e) {
            BasicDiagnostic thisDiagnostic = new BasicDiagnostic(4, ((Object)((Object)this)).getClass().getPackage().getName(), 0, "Failed to pre-generate " + genModel.getModelPluginID() + " constraints", new Object[]{e});
            Diagnostic thatDiagnostic = super.doPreGenerate(object, projectType);
            if (thatDiagnostic.getSeverity() == 0) {
                return thisDiagnostic;
            }
            thatDiagnostic.getChildren().add(thisDiagnostic);
            return thatDiagnostic;
        }
        return super.doPreGenerate(object, projectType);
    }

    protected Diagnostic generateModel(Object object, Monitor monitor) {
        GenModel genModel = (GenModel)object;
        try {
            if (!OCLGenModelGeneratorAdapter.useDelegates(genModel) && this.hadDelegates.contains(genModel)) {
                monitor.beginTask("", 4);
                monitor.subTask("Generating Dispatch Tables");
                GenPackage genPackage = (GenPackage)genModel.getGenPackages().get(0);
                this.createImportManager(genPackage.getReflectionPackageName(), String.valueOf(genPackage.getFactoryInterfaceName()) + "Tables");
                this.createDispatchTables(genModel, monitor);
                monitor.worked(1);
                this.createClassBodies(genModel, monitor);
                monitor.worked(1);
                if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    String modelProjectDirectory = genModel.getModelProjectDirectory();
                    IProject modelProject = workspace.getRoot().getProject(modelProjectDirectory);
                    modelProject.refreshLocal(2, BasicMonitor.toIProgressMonitor((Monitor)monitor));
                }
                monitor.worked(1);
            }
        }
        catch (Exception e) {
            BasicDiagnostic thisDiagnostic = new BasicDiagnostic(4, ((Object)((Object)this)).getClass().getPackage().getName(), 0, "Failed to generate " + genModel.getModelPluginID() + " tables and bodies", new Object[]{e});
            Diagnostic thatDiagnostic = super.generateModel(object, monitor);
            if (thatDiagnostic.getSeverity() == 0) {
                return thisDiagnostic;
            }
            thatDiagnostic.getChildren().add(thisDiagnostic);
            return thatDiagnostic;
        }
        return super.generateModel(object, monitor);
    }

    protected File getProjectFolder(GenModel genModel) {
        String modelProjectDirectory = genModel.getModelProjectDirectory();
        String modelDirectory = genModel.getModelDirectory();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject modelProject = workspace.getRoot().getProject(modelProjectDirectory);
            Path javaSource = new Path(modelDirectory);
            IFolder folder = modelProject.getParent().getFolder((IPath)javaSource);
            java.net.URI locationURI = folder.getLocationURI();
            return new File(locationURI.getRawPath());
        }
        URI locationURI = URI.createPlatformResourceURI((String)modelDirectory, (boolean)true);
        ResourceSet resourceSet = genModel.eResource().getResourceSet();
        URIConverter uriConverter = resourceSet != null ? resourceSet.getURIConverter() : URIConverter.INSTANCE;
        URI normalizedURI = uriConverter.normalize(locationURI);
        return new File(normalizedURI.toFileString());
    }

    protected boolean hasDelegates(GenModel genModel) {
        for (GenPackage genPackage : genModel.getGenPackages()) {
            EPackage ePackage = genPackage.getEcorePackage();
            if (!this.hasDelegates(ePackage)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDelegates(EPackage ePackage) {
        List validationDelegates = EcoreUtil.getValidationDelegates((EPackage)ePackage);
        for (String validationDelegate : validationDelegates) {
            if (!OCLCommon.isDelegateURI((String)validationDelegate)) continue;
            return true;
        }
        List settingDelegates = EcoreUtil.getSettingDelegates((EPackage)ePackage);
        for (String settingDelegate : settingDelegates) {
            if (!OCLCommon.isDelegateURI((String)settingDelegate)) continue;
            return true;
        }
        List invocationDelegates = EcoreUtil.getInvocationDelegates((EPackage)ePackage);
        for (String invocationDelegate : invocationDelegates) {
            if (!OCLCommon.isDelegateURI((String)invocationDelegate)) continue;
            return true;
        }
        return false;
    }

    protected void installJavaBodies(MetaModelManager metaModelManager, GenModel genModel, Map<String, String> results) {
        List genPackages = genModel.getAllGenPackagesWithClassifiers();
        for (GenPackage genPackage : genPackages) {
            EPackage ecorePackage = genPackage.getEcorePackage();
            Ecore2Pivot ecore2pivot = Ecore2Pivot.getAdapter((Resource)ecorePackage.eResource(), (MetaModelManager)metaModelManager);
            for (GenClass genClass : genPackage.getGenClasses()) {
                EClass eClass = genClass.getEcoreClass();
                for (EOperation eOperation : eClass.getEOperations()) {
                    this.installOperation(ecore2pivot, eOperation, results);
                }
                for (EStructuralFeature eFeature : eClass.getEStructuralFeatures()) {
                    this.installProperty(ecore2pivot, eFeature, results);
                }
            }
        }
    }

    protected void installOperation(Ecore2Pivot ecore2pivot, EOperation eOperation, Map<String, String> results) {
        String fragmentURI;
        Element pOperation = ecore2pivot.getCreated(Element.class, (EObject)eOperation);
        if (pOperation instanceof Operation) {
            fragmentURI = EcoreUtil.getURI((EObject)pOperation).fragment().toString();
        } else {
            Constraint constraint = (Constraint)pOperation;
            fragmentURI = String.valueOf(EcoreUtil.getURI((EObject)constraint.eContainer()).fragment().toString()) + "==" + constraint.getName();
        }
        String body = results.get(fragmentURI);
        if (body == null || body.trim().length() == 0) {
            body = "throw new UnsupportedOperationException();  // FIXME Unimplemented " + Pivot2Moniker.toString((Element)pOperation);
        }
        EcoreUtil.setAnnotation((EModelElement)eOperation, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"body", (String)body);
        EList eAnnotations = eOperation.getEAnnotations();
        EAnnotation oclAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL");
        if (oclAnnotation != null) {
            eAnnotations.remove(oclAnnotation);
        }
        if ((oclAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/LPG")) != null) {
            eAnnotations.remove(oclAnnotation);
        }
        if ((oclAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot")) != null) {
            eAnnotations.remove(oclAnnotation);
        }
        if ((oclAnnotation = eOperation.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel")) != null) {
            eAnnotations.remove(oclAnnotation);
        }
    }

    protected void installProperty(Ecore2Pivot ecore2pivot, EStructuralFeature eFeature, Map<String, String> results) {
        Property pProperty = (Property)ecore2pivot.getCreated(Property.class, (EObject)eFeature);
        String fragmentURI = EcoreUtil.getURI((EObject)pProperty).fragment().toString();
        String body = results.get(fragmentURI);
        if (body == null) {
            body = "throw new UnsupportedOperationException();  // FIXME Unimplemented " + Pivot2Moniker.toString((Element)pProperty);
        }
        if (body != null) {
            EcoreUtil.setAnnotation((EModelElement)eFeature, (String)"http://www.eclipse.org/emf/2002/GenModel", (String)"get", (String)body);
            EList eAnnotations = eFeature.getEAnnotations();
            EAnnotation oclAnnotation = eFeature.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL");
            if (oclAnnotation != null) {
                eAnnotations.remove(oclAnnotation);
            }
            if ((oclAnnotation = eFeature.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/LPG")) != null) {
                eAnnotations.remove(oclAnnotation);
            }
            if ((oclAnnotation = eFeature.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot")) != null) {
                eAnnotations.remove(oclAnnotation);
            }
            if ((oclAnnotation = eFeature.getEAnnotation("http://www.eclipse.org/uml2/1.1.0/GenModel")) != null) {
                eAnnotations.remove(oclAnnotation);
            }
        }
    }

    protected void pruneDelegates(GenModel genModel) {
        for (GenPackage genPackage : genModel.getGenPackages()) {
            EPackage ePackage = genPackage.getEcorePackage();
            if (!this.hasDelegates(ePackage)) continue;
            this.hadDelegates.add(genModel);
            EcoreUtil.setValidationDelegates((EPackage)ePackage, this.pruneDelegates(EcoreUtil.getValidationDelegates((EPackage)ePackage)));
            EcoreUtil.setSettingDelegates((EPackage)ePackage, this.pruneDelegates(EcoreUtil.getSettingDelegates((EPackage)ePackage)));
            EcoreUtil.setInvocationDelegates((EPackage)ePackage, this.pruneDelegates(EcoreUtil.getInvocationDelegates((EPackage)ePackage)));
        }
    }

    protected List<String> pruneDelegates(List<String> oldDelegates) {
        ArrayList<String> newDelegates = new ArrayList<String>();
        for (String aDelegate : oldDelegates) {
            if (OCLCommon.isDelegateURI((String)aDelegate)) continue;
            newDelegates.add(aDelegate);
        }
        return newDelegates;
    }
}

