/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.attributes;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeFilter;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOperationFilter
implements ScopeFilter {
    protected final MetaModelManager metaModelManager;
    protected final Type sourceType;

    public AbstractOperationFilter(MetaModelManager metaModelManager, Type sourceType) {
        this.metaModelManager = metaModelManager;
        this.sourceType = PivotUtil.getBehavioralType((Type)sourceType);
    }

    public int compareMatches(EObject match1, Map<TemplateParameter, ParameterableElement> bindings1, EObject match2, Map<TemplateParameter, ParameterableElement> bindings2) {
        int comparison = this.metaModelManager.compareOperationMatches((Operation)match1, bindings1, (Operation)match2, bindings2);
        return comparison;
    }

    protected Map<TemplateParameter, ParameterableElement> getOperationBindings(Operation candidateOperation) {
        Type sourceType = this.sourceType;
        if (!(sourceType instanceof CollectionType) && candidateOperation.getOwningType() instanceof CollectionType) {
            sourceType = this.metaModelManager.getCollectionType("Set", sourceType);
        }
        HashMap<TemplateParameter, Object> bindings = PivotUtil.getAllTemplateParameterSubstitutions(null, (TemplateableElement)sourceType);
        TemplateSignature templateSignature = candidateOperation.getOwnedTemplateSignature();
        if (templateSignature != null) {
            for (TemplateParameter templateParameter : templateSignature.getOwnedParameter()) {
                if (bindings == null) {
                    bindings = new HashMap<TemplateParameter, Object>();
                }
                bindings.put(templateParameter, null);
            }
        }
        return bindings;
    }

    protected void installBindings(EnvironmentView environmentView, Type forType, EObject eObject, Map<TemplateParameter, ParameterableElement> bindings) {
        environmentView.setBindings(eObject, bindings);
    }
}

